package cn.zhxu.bp.model;

import lombok.Getter;
import lombok.Setter;

import java.util.List;

import static cn.zhxu.bp.enums.SysConst.PushEvt;

/**
 * 推送消息
 * @author Troy.Zhou @ 2022/9/21
 * 适用于以下事件
 * @see PushEvt#ACCOUNT_USER_REGISTER
 * @see PushEvt#ACCOUNT_CONSOLE_CREATE
 * @see PushEvt#ACCOUNT_CONSOLE_UPDATE
 * @see PushEvt#ACCOUNT_API_CREATE
 * @see PushEvt#ACCOUNT_API_UPDATE
 */
@Getter
@Setter
public class UserMsg extends UserAdm {

    private List<String> roleKeys;
    private String address;
    private String remark;
    // 操作者编码
    private String actorNo;

}
