package cn.zhxu.bp.utils;

/**
 * @author Troy.Zhou
 */
public class StringUtils {

	public static char[] hexChars = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

	public static String toHexStr(byte[] bytes) {
        char[] str = new char[2 * bytes.length];
        int k = 0;
		for (byte b : bytes) {
			str[k++] = hexChars[b >>> 4 & 0xf];    //高4位
			str[k++] = hexChars[b & 0xf];        //低4位
		}
        return new String(str);
	}

	/**
	 * 字符串为 null 或者内部字符全部为 ' ' '\t' '\n' '\r' 这四类字符时返回 true
	 */
	public static boolean isBlank(String str) {
		if (str == null) {
			return true;
		}
		int len = str.length();
		if (len == 0) {
			return true;
		}
		for (int i = 0; i < len; i++) {
			switch (str.charAt(i)) {
			case ' ':
			case '\t':
			case '\n':
			case '\r':
			// case '\b':
			// case '\f':
				break;
			default:
				return false;
			}
		}
		return true;
	}
	
	public static boolean notBlank(String str) {
		return !isBlank(str);
	}
	
	public static boolean notBlank(String... strings) {
		if (strings == null) {
			return false;
		}
		for (String str : strings) {
			if (isBlank(str)) {
				return false;
			}
		}
		return true;
	}

    public static String join(Object[] array, String separator) {
        StringBuilder sb = new StringBuilder();
        for(int i = 0; i < array.length; i++){
            if(i == (array.length-1)) {
                sb.append(array[i]);
            } else{
                sb.append(array[i]).append(separator);
            }
        }
        return new String(sb);
    }


}
