/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bp.auth;

import cn.zhxu.bp.RespException;
import cn.zhxu.bp.auth.Scope;
import cn.zhxu.bp.enums.UserType;
import cn.zhxu.data.Array;
import cn.zhxu.data.Mapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Principal {
    private final int saasId;
    private final User user;
    public static final String SAAS_ID = "s";
    public static final String USER = "u";

    public boolean isSysGodVisit() {
        return this.user != null && this.user.isSysGodVisit(this.saasId);
    }

    public boolean isTopOrSubGodVisit() {
        return this.user != null && this.user.isTopOrSubGodVisit(this.saasId);
    }

    public User requireUser() {
        if (this.user == null) {
            throw RespException.forbidden("Current User is Null");
        }
        return this.user;
    }

    public Optional<User> optionalUser() {
        return Optional.ofNullable(this.user);
    }

    public Principal with(Scope scope) {
        if (this.user == null) {
            return this;
        }
        return new Principal(this.saasId, this.user.with(scope));
    }

    public Principal with(int saasId) {
        return new Principal(saasId, this.user);
    }

    public static Principal parse(Mapper mapper) {
        if (mapper.has(SAAS_ID)) {
            int saasId = mapper.getInt(SAAS_ID);
            Mapper user = mapper.getMapper(USER);
            return new Principal(saasId, User.parse(user));
        }
        throw new IllegalArgumentException(SAAS_ID);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(SAAS_ID, this.saasId);
        if (this.user != null) {
            map.put(USER, this.user.toMap());
        }
        return map;
    }

    public int getSaasId() {
        return this.saasId;
    }

    public User getUser() {
        return this.user;
    }

    public Principal(int saasId, User user) {
        this.saasId = saasId;
        this.user = user;
    }

    public String toString() {
        return "Principal(saasId=" + this.getSaasId() + ", user=" + this.getUser() + ")";
    }

    public static class User {
        private final long id;
        private final String no;
        private final int groupId;
        private final Scope scope;
        private final String name;
        private final UserType type;
        private final List<String> roleKeys;
        private final Map<String, Object> attrs;
        public static final String ID = "i";
        public static final String NO = "n";
        public static final String GROUP_ID = "g";
        public static final String SCOPE = "s";
        public static final String NAME = "m";
        public static final String TYPE = "t";
        public static final String ROLE_KEYS = "r";
        public static final String ATTRS = "a";

        public User(long id, String no, int groupId, String name, UserType type, List<String> roleKeys, Map<String, Object> attrs) {
            this(id, no, groupId, null, name, type, roleKeys, attrs);
        }

        public User(long id, String no, int groupId, Scope scope, String name, UserType type, List<String> roleKeys, Map<String, Object> attrs) {
            this.id = id;
            this.no = no;
            this.groupId = groupId;
            this.scope = scope;
            this.name = name;
            this.type = type;
            this.roleKeys = roleKeys;
            this.attrs = attrs;
        }

        public User with(Scope scope) {
            return new User(this.id, this.no, this.groupId, scope, this.name, this.type, this.roleKeys, this.attrs);
        }

        public boolean isSubGodUser() {
            Object value;
            if (this.type == UserType.SYS && (value = this.attrs.get("b")) != null) {
                String s = value.toString().toLowerCase();
                return Boolean.parseBoolean(s);
            }
            return false;
        }

        public boolean isSysGodUser() {
            Object value;
            if (this.type == UserType.SYS && (value = this.attrs.get("s")) != null) {
                String s = value.toString().toLowerCase();
                return Boolean.parseBoolean(s);
            }
            return false;
        }

        public boolean isTopUser() {
            return this.type == UserType.TOP;
        }

        public boolean isSysGodVisit(int saasId) {
            return this.isSysGodUser() && saasId == 0;
        }

        public boolean isTopOrSubGodVisit(int saasId) {
            return this.isTopUser() || this.isSubGodUser() && saasId > 0;
        }

        public Scope requireScope() {
            if (this.scope == null) {
                throw RespException.forbidden("Scope is NULL");
            }
            return this.scope;
        }

        public static User parse(Mapper mapper) {
            if (mapper == null) {
                return null;
            }
            long id = mapper.getLong(ID);
            String no = mapper.getString(NO);
            int groupId = mapper.getInt(GROUP_ID);
            Mapper scope = mapper.getMapper("s");
            String name = mapper.getString(NAME);
            int type = mapper.getInt(TYPE);
            Array roleKeys = mapper.getArray(ROLE_KEYS);
            Mapper attr = mapper.getMapper(ATTRS);
            return new User(id, no, groupId, Scope.parse(scope), name, UserType.of(type), roleKeys.toList(String.class), attr.toMap());
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(ID, this.id);
            map.put(NO, this.no);
            map.put(NAME, this.name);
            map.put(GROUP_ID, this.groupId);
            if (this.scope != null) {
                map.put("s", this.scope.toMap());
            }
            map.put(TYPE, this.type.getValue());
            map.put(ROLE_KEYS, this.roleKeys);
            map.put(ATTRS, this.attrs);
            return map;
        }

        public String idName() {
            return "[" + this.id + "]" + this.name;
        }

        public long getId() {
            return this.id;
        }

        public String getNo() {
            return this.no;
        }

        public int getGroupId() {
            return this.groupId;
        }

        public Scope getScope() {
            return this.scope;
        }

        public String getName() {
            return this.name;
        }

        public UserType getType() {
            return this.type;
        }

        public List<String> getRoleKeys() {
            return this.roleKeys;
        }

        public Map<String, Object> getAttrs() {
            return this.attrs;
        }

        public static interface AttrKeys {
            public static final String SYS_GOD = "s";
            public static final String SUB_GOD = "b";
        }
    }
}

