/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bp.auth;

import cn.zhxu.bp.enums.ScopeType;
import cn.zhxu.bp.utils.StringUtils;
import cn.zhxu.data.Mapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Scope {
    private final ScopeType type;
    private final String groupIds;
    static final String TYPE = "type";
    static final String GROUP_IDS = "groupIds";

    public Scope(ScopeType type) {
        this(type, "-1");
    }

    public Scope(ScopeType type, List<Integer> groupIds) {
        this(type, StringUtils.join(groupIds.toArray(), ","));
    }

    public Scope(ScopeType type, String groupIds) {
        this.type = type;
        this.groupIds = StringUtils.isBlank(groupIds) ? "-1" : groupIds;
    }

    public List<Integer> groupIdList() {
        if (this.groupIds == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.groupIds.split(",")).map(Integer::parseInt).collect(Collectors.toList());
    }

    public boolean isEmptyGroup() {
        return StringUtils.isBlank(this.groupIds) || this.groupIds.trim().equals("-1");
    }

    public static Scope parse(Mapper mapper) {
        if (mapper == null) {
            return null;
        }
        ScopeType type = ScopeType.from(mapper.getInt(TYPE));
        if (type == null) {
            return null;
        }
        String groupIds = mapper.getString(GROUP_IDS);
        return new Scope(type, groupIds);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(TYPE, this.type.value());
        map.put(GROUP_IDS, this.groupIds);
        return map;
    }

    public ScopeType getType() {
        return this.type;
    }

    public String getGroupIds() {
        return this.groupIds;
    }
}

