/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bp.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AuthRule {
    static final int TYPE_AUTHORITY = 1;
    static final int TYPE_OR_GROUP = 3;
    private final int type;
    private List<String> auths;
    private List<AuthRule> orRules;

    AuthRule(int type) {
        this.type = type;
    }

    public static AuthRule from(String authAttr) {
        if (authAttr.contains("|")) {
            AuthRule authRule = new AuthRule(3);
            for (String authAttr0 : authAttr.split("\\|")) {
                AuthRule rule = new AuthRule(1);
                rule.auths = Arrays.asList(authAttr0.split("&"));
                authRule.addOrRule(rule);
            }
            return authRule;
        }
        AuthRule rule = new AuthRule(1);
        rule.auths = Arrays.asList(authAttr.split("&"));
        return rule;
    }

    private void addOrRule(AuthRule rule) {
        if (this.orRules == null) {
            this.orRules = new ArrayList<AuthRule>(1);
        }
        this.orRules.add(rule);
    }

    public boolean isPermitAll() {
        return this.isPermit(Collections.emptyList());
    }

    public boolean isPermit(List<String> authorities) {
        if (this.type == 1) {
            for (String auth : this.auths) {
                if ("permitAll".equals(auth) || authorities.contains(auth)) continue;
                return false;
            }
            return true;
        }
        if (this.type == 3) {
            for (AuthRule rule : this.orRules) {
                if (!rule.isPermit(authorities)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

