/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bp.auth;

import cn.zhxu.bp.enums.ScopeType;
import cn.zhxu.bp.utils.StringUtils;
import cn.zhxu.data.Mapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class Scope {
    private final ScopeType type;
    private final String groupIds;
    static final String TYPE = "t";
    static final String GROUP_IDS = "g";

    public Scope(ScopeType type) {
        this(type, "-1");
    }

    public Scope(ScopeType type, List<Integer> groupIds) {
        this(type, StringUtils.join(groupIds.toArray(), ","));
    }

    public Scope(ScopeType type, String groupIds) {
        this.type = type;
        this.groupIds = StringUtils.isBlank(groupIds) ? "-1" : groupIds;
    }

    public List<Integer> groupIdList() {
        if (this.groupIds == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.groupIds.split(",")).map(Integer::parseInt).collect(Collectors.toList());
    }

    public boolean isEmptyGroup() {
        return StringUtils.isBlank(this.groupIds) || this.groupIds.trim().equals("-1");
    }

    public boolean scoped(int groupId) {
        if (this.type == ScopeType.ALL) {
            return true;
        }
        if (this.type == ScopeType.ONLY_SELF) {
            return false;
        }
        return this.groupIdList().contains(groupId);
    }

    public static Scope parse(Mapper mapper) {
        if (mapper == null) {
            return null;
        }
        ScopeType type = ScopeType.from(mapper.getInt(TYPE));
        if (type == null) {
            return null;
        }
        String groupIds = mapper.getString(GROUP_IDS);
        return new Scope(type, groupIds);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(TYPE, this.type.value());
        map.put(GROUP_IDS, this.groupIds);
        return map;
    }

    @Generated
    public ScopeType getType() {
        return this.type;
    }

    @Generated
    public String getGroupIds() {
        return this.groupIds;
    }

    @Generated
    public String toString() {
        return "Scope(type=" + this.getType() + ", groupIds=" + this.getGroupIds() + ")";
    }
}

