/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bp.utils;

import cn.zhxu.bp.utils.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtils {
    public static byte[] toMd5(byte[] source) {
        try {
            return DigestUtils.digest(source, "MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("\u6ca1\u6709 MD5 \u7b97\u6cd5\uff1a", e);
        }
    }

    public static String toMd5(String source) {
        return DigestUtils.toMd5(source, StandardCharsets.UTF_8);
    }

    public static String toMd5(String source, Charset charset) {
        try {
            return DigestUtils.digest(source, "MD5", charset);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("\u6ca1\u6709 MD5 \u7b97\u6cd5\uff1a", e);
        }
    }

    public static byte[] toSha1(byte[] source) {
        try {
            return DigestUtils.digest(source, "SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("\u6ca1\u6709 SHA-1 \u7b97\u6cd5\uff1a", e);
        }
    }

    public static String toSha1(String source) {
        return DigestUtils.toSha1(source, StandardCharsets.UTF_8);
    }

    public static String toSha1(String source, Charset charset) {
        try {
            return DigestUtils.digest(source, "SHA-1", charset);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("\u6ca1\u6709 SHA-1 \u7b97\u6cd5\uff1a", e);
        }
    }

    public static byte[] toSha224(byte[] source) {
        try {
            return DigestUtils.digest(source, "SHA-224");
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("\u6ca1\u6709 SHA-224 \u7b97\u6cd5\uff1a", e);
        }
    }

    public static String toSha224(String source) {
        return DigestUtils.toSha224(source, StandardCharsets.UTF_8);
    }

    public static String toSha224(String source, Charset charset) {
        try {
            return DigestUtils.digest(source, "SHA-224", charset);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("\u6ca1\u6709 SHA-224 \u7b97\u6cd5\uff1a", e);
        }
    }

    public static byte[] toSha256(byte[] source) {
        try {
            return DigestUtils.digest(source, "SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("\u6ca1\u6709 SHA-224 \u7b97\u6cd5\uff1a", e);
        }
    }

    public static String toSha256(String source) {
        return DigestUtils.toSha256(source, StandardCharsets.UTF_8);
    }

    public static String toSha256(String source, Charset charset) {
        try {
            return DigestUtils.digest(source, "SHA-256", charset);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("\u6ca1\u6709 SHA-256 \u7b97\u6cd5\uff1a", e);
        }
    }

    public static byte[] toSha512(byte[] source) {
        try {
            return DigestUtils.digest(source, "SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("\u6ca1\u6709 SHA-512 \u7b97\u6cd5\uff1a", e);
        }
    }

    public static String toSha512(String source) {
        return DigestUtils.toSha512(source, StandardCharsets.UTF_8);
    }

    public static String toSha512(String source, Charset charset) {
        try {
            return DigestUtils.digest(source, "SHA-512", charset);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException("\u6ca1\u6709 SHA-512 \u7b97\u6cd5\uff1a", e);
        }
    }

    public static String digest(String source, String algorithm) throws NoSuchAlgorithmException {
        return DigestUtils.digest(source, algorithm, StandardCharsets.UTF_8);
    }

    public static String digest(String source, String algorithm, Charset charset) throws NoSuchAlgorithmException {
        if (source == null) {
            return null;
        }
        byte[] bytes = DigestUtils.digest(source.getBytes(charset), algorithm);
        return StringUtils.toHexStr(bytes);
    }

    public static byte[] digest(byte[] source, String algorithm) throws NoSuchAlgorithmException {
        if (source == null) {
            return null;
        }
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(source);
        return md.digest();
    }

    public static class DigestException
    extends RuntimeException {
        public DigestException(String arg0, Throwable arg1) {
            super(arg0, arg1);
        }
    }
}

