/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bp.utils;

import cn.zhxu.bp.utils.StringUtils;
import cn.zhxu.xjson.JsonKit;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Reflections {
    public static List<Field> getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        HashSet<String> names = new HashSet<String>();
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                String name = field.getName();
                if (field.isSynthetic() || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || names.contains(name)) continue;
                fields.add(field);
                names.add(name);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static <T> T newInstance(Class<T> clazz, List<Field> fields, String[] values) {
        if (fields.size() != values.length) {
            throw new IllegalArgumentException("fields \u4e0e values \u7684\u4e2a\u6570\u4e0d\u5339\u914d");
        }
        T bean = Reflections.newInstance(clazz);
        for (int i = 0; i < values.length; ++i) {
            Field field = fields.get(i);
            String value = values[i];
            if (value == null || StringUtils.isBlank(value) && field.getType() != String.class) continue;
            field.setAccessible(true);
            try {
                field.set(bean, Reflections.convert(field, value));
                continue;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("A exception occurred when setting value to [" + clazz.getName() + "#" + field.getName() + "], please check whether it's setter is correct.", e);
            }
        }
        return bean;
    }

    public static Object convert(Field field, String value) {
        Type genericType;
        Class<?> type = field.getType();
        if (type == String.class) {
            return value;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.parseInt(value);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.parseLong(value);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.parseDouble(value);
        }
        if (type == Short.TYPE || type == Short.class) {
            return Short.parseShort(value);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return Byte.parseByte(value);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(value);
        }
        if (List.class.isAssignableFrom(type) && (genericType = field.getGenericType()) instanceof ParameterizedType) {
            Type itemType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            return JsonKit.toList((Class)((Class)itemType), (String)value);
        }
        return JsonKit.toBean(type, (String)value);
    }

    public static <T> T newInstance(Class<T> beanClass) {
        try {
            return beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Can not instantiate [" + beanClass.getName() + "], please check whether there is a constructor without parameters on it.", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not instantiate [" + beanClass.getName() + "], please check whether the constructor without parameters can be invoked without errors.", e);
        }
    }
}

