/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.data.fastjson;

import cn.zhxu.data.Array;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.fastjson.FastjsonMapper;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.List;

public class FastjsonArray
implements Array {
    private final JSONArray json;

    public FastjsonArray(JSONArray json) {
        this.json = json;
    }

    public int size() {
        return this.json.size();
    }

    public boolean isEmpty() {
        return this.json.isEmpty();
    }

    public Mapper getMapper(int index) {
        JSONObject subJson = this.json.getJSONObject(index);
        if (subJson != null) {
            return new FastjsonMapper(subJson);
        }
        return null;
    }

    public Array getArray(int index) {
        JSONArray subJson = this.json.getJSONArray(index);
        if (subJson != null) {
            return new FastjsonArray(subJson);
        }
        return null;
    }

    public boolean getBool(int index) {
        return this.json.getBooleanValue(index);
    }

    public int getInt(int index) {
        return this.json.getIntValue(index);
    }

    public long getLong(int index) {
        return this.json.getLongValue(index);
    }

    public float getFloat(int index) {
        return this.json.getFloatValue(index);
    }

    public double getDouble(int index) {
        return this.json.getDoubleValue(index);
    }

    public String getString(int index) {
        return this.json.getString(index);
    }

    public <T> List<T> toList(Class<T> type) {
        return this.json.toJavaList(type);
    }

    public List<Object> toList() {
        return this.json;
    }

    public String toPretty() {
        return this.json.toString(new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    public String toString() {
        return this.json.toJSONString();
    }
}

