/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.data.fastjson;

import cn.zhxu.data.Array;
import cn.zhxu.data.DataConvertor;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.fastjson.FastjsonArray;
import cn.zhxu.data.fastjson.FastjsonMapper;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;

public class FastjsonDataConvertor
implements DataConvertor {
    public Mapper toMapper(InputStream in, Charset charset) {
        return this.toMapper(this.toString(in, charset));
    }

    public Mapper toMapper(String in) {
        return new FastjsonMapper(JSON.parseObject((String)in));
    }

    public Array toArray(InputStream in, Charset charset) {
        return this.toArray(this.toString(in, charset));
    }

    public Array toArray(String in) {
        return new FastjsonArray(JSON.parseArray((String)in));
    }

    public byte[] serialize(Object object, Charset charset) {
        return this.serialize(object, false).getBytes(charset);
    }

    public byte[] serialize(Object object, Charset charset, boolean pretty) {
        return this.serialize(object, pretty).getBytes(charset);
    }

    public String serialize(Object object, boolean pretty) {
        if (object instanceof Mapper) {
            object = ((Mapper)object).toMap();
        }
        if (object instanceof Array) {
            object = ((Array)object).toList();
        }
        if (pretty) {
            return JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
        }
        return JSON.toJSONString((Object)object);
    }

    public <T> T toBean(Type type, InputStream in, Charset charset) {
        try {
            return (T)JSON.parseObject((InputStream)in, (Charset)charset, (Type)type, (Feature[])new Feature[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T> T toBean(Type type, String in) {
        return (T)JSON.parseObject((String)in, (Type)type, (Feature[])new Feature[0]);
    }

    public <T> List<T> toList(Class<T> type, InputStream in, Charset charset) {
        return this.toList(type, this.toString(in, charset));
    }

    public <T> List<T> toList(Class<T> type, String in) {
        return JSON.parseArray((String)in, type);
    }

    protected String toString(InputStream in, Charset charset) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buff = new byte[512];
        try {
            int len;
            while ((len = in.read(buff)) > 0) {
                output.write(buff, 0, len);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        try {
            return output.toString(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

