/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.data.snack3;

import cn.zhxu.data.Array;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.TypeRef;
import cn.zhxu.data.snack3.Snack3Array;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.noear.snack.ONode;

public class Snack3Mapper
implements Mapper {
    private final ONode json;

    public Snack3Mapper(ONode json) {
        if (!json.isObject()) {
            throw new IllegalArgumentException("illegal json object type");
        }
        this.json = json;
    }

    public int size() {
        return this.json.count();
    }

    public boolean isEmpty() {
        return this.json.count() == 0;
    }

    public Mapper getMapper(String key) {
        ONode subJson = this.json.get(key);
        if (subJson != null && subJson.isObject()) {
            return new Snack3Mapper(subJson);
        }
        return null;
    }

    public Array getArray(String key) {
        ONode subJson = this.json.get(key);
        if (subJson != null && subJson.isArray()) {
            return new Snack3Array(subJson);
        }
        return null;
    }

    public boolean getBool(String key) {
        return this.json.get(key).getBoolean();
    }

    public int getInt(String key) {
        return this.json.get(key).getInt();
    }

    public long getLong(String key) {
        return this.json.get(key).getLong();
    }

    public float getFloat(String key) {
        return this.json.get(key).getFloat();
    }

    public double getDouble(String key) {
        return this.json.get(key).getDouble();
    }

    public String getString(String key) {
        return this.json.get(key).getString();
    }

    public boolean has(String key) {
        return this.json.contains(key);
    }

    public Set<String> keySet() {
        return this.json.obj().keySet();
    }

    public String toString() {
        return this.json.toJson();
    }

    public <T> T toBean(Type type) {
        return (T)this.json.toObject(type);
    }

    public <T> T toBean(Class<T> type) {
        return (T)this.json.toObject(type);
    }

    public <T> T toBean(TypeRef<T> type) {
        return (T)this.json.toObject(type.getType());
    }

    public Map<String, Object> toMap() {
        return (Map)this.json.toObject(Map.class);
    }
}

