/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.data.snack3;

import cn.zhxu.data.Array;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.snack3.Snack3Mapper;
import java.util.List;
import org.noear.snack.ONode;
import org.noear.snack.core.Context;
import org.noear.snack.core.DEFAULTS;
import org.noear.snack.core.Feature;
import org.noear.snack.core.Handler;
import org.noear.snack.core.Options;

public class Snack3Array
implements Array {
    private final ONode json;

    public Snack3Array(ONode json) {
        if (!json.isArray()) {
            throw new IllegalArgumentException("illegal json array type");
        }
        this.json = json;
    }

    public int size() {
        return this.json.count();
    }

    public boolean isEmpty() {
        return this.json.count() == 0;
    }

    public Mapper getMapper(int index) {
        ONode subJson = this.json.get(index);
        if (subJson != null && subJson.isObject()) {
            return new Snack3Mapper(subJson);
        }
        return null;
    }

    public Array getArray(int index) {
        ONode subJson = this.json.get(index);
        if (subJson != null && subJson.isArray()) {
            return new Snack3Array(subJson);
        }
        return null;
    }

    public boolean getBool(int index) {
        return this.json.get(index).getBoolean();
    }

    public int getInt(int index) {
        return this.json.get(index).getInt();
    }

    public long getLong(int index) {
        return this.json.get(index).getLong();
    }

    public float getFloat(int index) {
        return this.json.get(index).getFloat();
    }

    public double getDouble(int index) {
        return this.json.get(index).getDouble();
    }

    public String getString(int index) {
        return this.json.get(index).getString();
    }

    public <T> List<T> toList(Class<T> type) {
        return this.json.toObjectList(type);
    }

    public List<Object> toList() {
        return (List)this.json.toObject(List.class);
    }

    public String toPretty() {
        Options options = new Options(this.json.options().getFeatures()).add(new Feature[]{Feature.PrettyFormat});
        Context context = new Context(options, this.json, null).handle((Handler)DEFAULTS.DEF_JSON_TOER);
        return (String)context.target;
    }

    public ONode getJson() {
        return this.json;
    }

    public String toString() {
        return this.json.toJson();
    }
}

