/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.stomp;

import cn.zhxu.stomp.Header;
import java.util.List;

public class Message {
    private final String command;
    private final List<Header> headers;
    private final String payload;

    public Message(String command, List<Header> headers) {
        this(command, headers, null);
    }

    public Message(String command, List<Header> headers, String payload) {
        this.command = command;
        this.headers = headers;
        this.payload = payload;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getCommand() {
        return this.command;
    }

    public String headerValue(String key) {
        Header header = this.header(key);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public Header header(String key) {
        if (this.headers != null) {
            for (Header header : this.headers) {
                if (!header.getKey().equals(key)) continue;
                return header;
            }
        }
        return null;
    }

    public String toString() {
        return "Message {command='" + this.command + "', headers=" + this.headers + ", payload='" + this.payload + "'}";
    }
}

