/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.stomp;

import cn.zhxu.okhttps.Platform;
import cn.zhxu.okhttps.WHttpTask;
import cn.zhxu.okhttps.WebSocket;
import cn.zhxu.stomp.Header;
import cn.zhxu.stomp.Message;
import cn.zhxu.stomp.MsgCodec;
import cn.zhxu.stomp.MsgCodecImpl;
import cn.zhxu.stomp.Subscriber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.function.Consumer;

public class Stomp {
    private static final String TOPIC = "/topic";
    private static final String QUEUE = "/queue";
    public static final String SUPPORTED_VERSIONS = "1.1,1.2";
    public static final String AUTO_ACK = "auto";
    public static final String CLIENT_ACK = "client";
    private final boolean autoAck;
    private boolean connected = false;
    private boolean connecting = false;
    private boolean disconnecting = false;
    private final WHttpTask task;
    private WebSocket websocket;
    private final List<Subscriber> subscribers;
    private Consumer<Stomp> onConnected;
    private Consumer<WebSocket.Close> onDisconnected;
    private Consumer<Throwable> onException;
    private Consumer<Message> onError;
    private final String disReceipt;
    private MsgCodec msgCodec = new MsgCodecImpl();

    private Stomp(WHttpTask task, boolean autoAck) {
        this.task = task;
        this.autoAck = autoAck;
        this.subscribers = Collections.synchronizedList(new ArrayList());
        this.disReceipt = UUID.randomUUID().toString();
    }

    public static Stomp over(WHttpTask task) {
        return Stomp.over(task, true);
    }

    public static Stomp over(WHttpTask task, boolean autoAck) {
        return new Stomp(task, autoAck);
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public Stomp connect() {
        return this.connect(null);
    }

    public synchronized Stomp connect(List<Header> headers) {
        if (this.connected || this.connecting) {
            return this;
        }
        this.websocket = this.task.setOnOpen((ws, res) -> this.doOnOpened(headers)).setOnMessage((ws, msg) -> this.msgCodec.decode(msg.toString(), this::receive)).setOnException((ws, e) -> this.doOnException((Throwable)e)).setOnClosed((ws, close) -> this.doOnClosed((WebSocket.Close)close)).listen();
        this.connecting = true;
        this.disconnecting = false;
        return this;
    }

    private synchronized void doOnOpened(List<Header> headers) {
        if (this.websocket != null) {
            int pingSecs = this.task.pingSeconds();
            int pongSecs = this.task.pongSeconds();
            ArrayList<Header> cHeaders = new ArrayList<Header>();
            cHeaders.add(new Header("accept-version", SUPPORTED_VERSIONS));
            if (pingSecs > 0 && pongSecs > 0) {
                cHeaders.add(new Header("heart-beat", pingSecs * 1000 + "," + pongSecs * 1000));
            }
            if (headers != null) {
                cHeaders.addAll(headers);
            }
            this.send(new Message("CONNECT", cHeaders, null));
        }
    }

    private synchronized void doOnException(Throwable throwable) {
        Consumer<Throwable> listener = this.onException;
        if (listener != null) {
            listener.accept(throwable);
        }
        this.disconnecting = false;
        this.connecting = false;
    }

    private synchronized void doOnClosed(WebSocket.Close close) {
        this.connected = false;
        this.connecting = false;
        this.disconnecting = false;
        this.websocket = null;
        for (Subscriber subscriber : this.subscribers) {
            subscriber.resetStatus();
        }
        Consumer<WebSocket.Close> listener = this.onDisconnected;
        if (listener != null) {
            listener.accept(close);
        }
    }

    public boolean isConnected() {
        return this.connected && this.websocket != null;
    }

    public boolean isConnecting() {
        return this.connecting && this.websocket != null;
    }

    public boolean isDisconnecting() {
        return this.disconnecting && this.websocket != null;
    }

    public void disconnect() {
        this.disconnect(10);
    }

    public void disconnect(int maxWaitSeconds) {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Stomp.this.disconnect(true);
            }
        }, 1000L * (long)maxWaitSeconds);
        Header header = new Header("receipt", this.disReceipt);
        List<Header> headers = Collections.singletonList(header);
        this.send(new Message("DISCONNECT", headers));
        this.disconnecting = true;
        this.connecting = false;
    }

    public synchronized void disconnect(boolean immediate) {
        if (immediate) {
            WebSocket ws = this.websocket;
            if (ws != null) {
                ws.close(1000, "disconnect by user");
                this.websocket = null;
            }
        } else {
            this.disconnect(10);
        }
    }

    public Stomp setOnConnected(Consumer<Stomp> onConnected) {
        this.onConnected = onConnected;
        return this;
    }

    public Stomp setOnDisconnected(Consumer<WebSocket.Close> onDisconnected) {
        this.onDisconnected = onDisconnected;
        return this;
    }

    public Stomp setOnException(Consumer<Throwable> onException) {
        this.onException = onException;
        return this;
    }

    public Stomp setOnError(Consumer<Message> onError) {
        this.onError = onError;
        return this;
    }

    public void sendToTopic(String destination, String data) {
        this.sendTo(TOPIC + destination, data);
    }

    public void sendToQueue(String destination, String data) {
        this.sendTo(QUEUE + destination, data);
    }

    public void sendTo(String destination, String data) {
        this.send(new Message("SEND", Collections.singletonList(new Header("destination", destination)), data));
    }

    public void send(Message message) {
        WebSocket ws = this.websocket;
        if (ws == null) {
            throw new IllegalArgumentException("You must call connect before send");
        }
        ws.send((Object)this.msgCodec.encode(message));
    }

    public Stomp topic(String destination, Consumer<Message> callback) {
        return this.topic(destination, null, callback);
    }

    public Stomp topic(String destination, List<Header> headers, Consumer<Message> callback) {
        return this.subscribe(TOPIC + destination, headers, callback);
    }

    public Stomp queue(String destination, Consumer<Message> callback) {
        return this.queue(destination, null, callback);
    }

    public Stomp queue(String destination, List<Header> headers, Consumer<Message> callback) {
        return this.subscribe(QUEUE + destination, headers, callback);
    }

    public synchronized Stomp subscribe(String destination, List<Header> headers, Consumer<Message> callback) {
        if (destination == null || destination.isEmpty()) {
            throw new IllegalArgumentException("destination can not be empty!");
        }
        for (Subscriber s : this.subscribers) {
            if (!s.destinationEqual(destination)) continue;
            Platform.logError((String)("The destination [" + destination + "] has already been subscribed!"));
            return this;
        }
        Subscriber subscriber = new Subscriber(this, destination, callback, headers);
        this.subscribers.add(subscriber);
        subscriber.subscribe();
        return this;
    }

    public void ack(Message message) {
        Header subscription = message.header("subscription");
        Header msgId = message.header("message-id");
        if (subscription != null || msgId != null) {
            ArrayList<Header> headers = new ArrayList<Header>();
            headers.add(subscription);
            headers.add(msgId);
            this.send(new Message("ACK", headers, null));
        } else {
            Platform.logError((String)("subscription and message-id not found in " + message + ", so it can not be ack!"));
        }
    }

    public void untopic(String destination) {
        this.unsubscribe(TOPIC + destination);
    }

    public void unqueue(String destination) {
        this.unsubscribe(QUEUE + destination);
    }

    public synchronized void unsubscribe(String destination) {
        Iterator<Subscriber> it = this.subscribers.iterator();
        while (it.hasNext()) {
            Subscriber s = it.next();
            if (!s.destinationEqual(destination)) continue;
            s.unsubscribe();
            it.remove();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void receive(Message msg) {
        String command = msg.getCommand();
        if ("CONNECTED".equals(command)) {
            String hbHeader = msg.headerValue("heart-beat");
            Stomp stomp = this;
            synchronized (stomp) {
                this.connected = true;
                this.connecting = false;
                this.onConnectedFrameReceived(hbHeader);
            }
        } else if ("MESSAGE".equals(command)) {
            String id = msg.headerValue("subscription");
            if (id != null) {
                for (Subscriber s : this.subscribers) {
                    if (s.tryCallback(id, msg)) break;
                }
            }
        } else if ("RECEIPT".equals(command)) {
            if (this.disReceipt.equals(msg.headerValue("receipt-id"))) {
                this.disconnect(true);
            }
        } else if ("ERROR".equals(command)) {
            Consumer<Message> listener = this.onError;
            if (listener != null) {
                listener.accept(msg);
            }
            this.connecting = false;
        }
    }

    private void onConnectedFrameReceived(String hbHeader) {
        Consumer<Stomp> listener;
        int pingSecs = this.task.pingSeconds();
        int pongSecs = this.task.pongSeconds();
        if (hbHeader != null && (pingSecs > 0 || pongSecs > 0)) {
            String[] heartbeats = hbHeader.split(",");
            int pingSeconds = Integer.parseInt(heartbeats[1]) / 1000;
            int pongSeconds = Integer.parseInt(heartbeats[0]) / 1000;
            if (pingSeconds > 0 || pongSeconds > 0) {
                if (this.task.pingSupplier() == null) {
                    this.task.pingSupplier(() -> "\n");
                }
                this.task.heatbeat(Math.max(pingSeconds, pingSecs), Math.max(pongSeconds, pongSecs));
            }
        }
        if ((listener = this.onConnected) != null) {
            listener.accept(this);
        }
        for (Subscriber subscriber : this.subscribers) {
            subscriber.subscribe();
        }
    }

    public MsgCodec getMsgCodec() {
        return this.msgCodec;
    }

    public void setMsgCodec(MsgCodec msgCodec) {
        this.msgCodec = msgCodec;
    }
}

