/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.stomp;

import cn.zhxu.stomp.Header;
import cn.zhxu.stomp.Message;
import cn.zhxu.stomp.Stomp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;

public class Subscriber {
    private final Stomp stomp;
    private final String id;
    private final String destination;
    private final Consumer<Message> callback;
    private final List<Header> headers;
    private boolean subscribed;

    public Subscriber(Stomp stomp, String destination, Consumer<Message> callback, List<Header> headers) {
        this.stomp = stomp;
        this.id = UUID.randomUUID().toString();
        this.destination = destination;
        this.callback = callback;
        this.headers = headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe() {
        Stomp stomp = this.stomp;
        synchronized (stomp) {
            if (this.subscribed) {
                return;
            }
            if (this.stomp.isConnected()) {
                this.doSubscribe();
            }
        }
    }

    private void doSubscribe() {
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add(new Header("id", this.id));
        headers.add(new Header("destination", this.destination));
        boolean ackNotAdded = true;
        if (this.headers != null) {
            for (Header header : this.headers) {
                String key;
                if ("ack".equals(header.getKey())) {
                    ackNotAdded = false;
                }
                if ("id".equals(key = header.getKey()) || "destination".equals(key)) continue;
                headers.add(header);
            }
        }
        if (ackNotAdded) {
            headers.add(new Header("ack", this.stomp.isAutoAck() ? "auto" : "client"));
        }
        this.stomp.send(new Message("SUBSCRIBE", headers, null));
        this.subscribed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe() {
        Stomp stomp = this.stomp;
        synchronized (stomp) {
            if (this.stomp.isConnected()) {
                List<Header> headers = Collections.singletonList(new Header("id", this.id));
                this.stomp.send(new Message("UNSUBSCRIBE", headers, null));
            }
        }
        this.resetStatus();
    }

    public void resetStatus() {
        this.subscribed = false;
    }

    public boolean destinationEqual(String destination) {
        return destination != null && destination.equals(this.destination);
    }

    public boolean tryCallback(String id, Message msg) {
        if (this.id.equals(id)) {
            this.callback.accept(msg);
            return true;
        }
        return false;
    }
}

