package cn.zhxu.toys.captcha.impl;

import cn.zhxu.toys.cache.CacheService;
import cn.zhxu.toys.captcha.Captcha;
import cn.zhxu.toys.captcha.CaptchaService;

/**
 * 
 * 验证码 Redis 存储器
 * 
 * @author Troy
 *
 */
public class DefaultCaptchaService implements CaptchaService {

	private String keyPrefix = "captcha";

	private CacheService cacheService;

	/**
	 * 存储时间：半小时
	 */
	private int cacheSeconds = 1800;


	public DefaultCaptchaService() {
	}

	public DefaultCaptchaService(CacheService cacheService) {
		this.cacheService = cacheService;
	}

	@Override
	public Captcha findCaptcha(String captchaId) {
		return cacheService.cache(key(captchaId), CaptchaBean.class);
	}
	
	@Override
	public void save(String captchaId, String code, int expireSeconds) {
		CaptchaBean captcha = new CaptchaBean();
		captcha.setCode(code);
		captcha.setExpireTime(System.currentTimeMillis() / 1000 + expireSeconds);
		cacheService.cache(key(captchaId), cacheSeconds, captcha);
	}

	@Override
	public void delete(String captchaId) {
		cacheService.delete(key(captchaId));
	}

	private String key(String captchaId) {
		return keyPrefix + ":" + captchaId;
	}

	public String getKeyPrefix() {
		return keyPrefix;
	}

	public void setKeyPrefix(String keyPrefix) {
		this.keyPrefix = keyPrefix;
	}

	public CacheService getCacheService() {
		return cacheService;
	}

	public void setCacheService(CacheService cacheService) {
		this.cacheService = cacheService;
	}

	public int getCacheSeconds() {
		return cacheSeconds;
	}

	public void setCacheSeconds(int cacheSeconds) {
		this.cacheSeconds = cacheSeconds;
	}

}
