package cn.zhxu.toys.push;

import java.util.Map;

/**
 * 
 * 推送管理器
 * 
 * @author Troy.Zhou
 *
 */
public interface PushManager {

	/**
	 * 推送给所有用户
	 * @param title 消息标题
	 * @param message 消息内容
	 * @return 推送结果
	 */
	PushResult pushToAll(String title, String message);
	
	/**
	 * 推送给所有用户
	 * @param title 消息标题
	 * @param message 消息内容
	 * @param data 业务数据
	 * @return 推送结果
	 */
	PushResult pushToAll(String title, String message, Map<String, Object> data);
	
	/**
	 * 推送给指定用户
	 * @param title 消息标题
	 * @param message 消息内容
	 * @param userId 指定的用户ID（别名）
	 * @return 推送结果
	 */
	PushResult pushToUser(String title, String message, String... userId);
	
	/**
	 * 推送给指定用户
	 * @param title 消息标题
	 * @param message 消息内容
	 * @param data 业务数据
	 * @param userId 指定的用户ID（别名）
	 * @return 推送结果
	 */
	PushResult pushToUser(String title, String message, Map<String, Object> data, String... userId);
	
	/**
	 * 推送给Android平台所有用户
	 * @param title 消息标题
	 * @param message 消息内容
	 * @return 推送结果
	 */
	PushResult pushToAndroid(String title, String message);
	
	
	/**
	 * 推送给Android平台所有用户
	 * @param title 消息标题
	 * @param message 消息内容
	 * @param data 业务数据
	 * @return 推送结果
	 */
	PushResult pushToAndroid(String title, String message, Map<String, Object> data);
	
	/**
	 * 推送给Android平台指定用户
	 * @param title 消息标题
	 * @param message 消息内容
	 * @param userId 指定的用户ID（别名）
	 * @return 推送结果
	 */
	PushResult pushToAndroidUser(String title, String message, String... userId);
	
	/**
	 * 推送给Android平台指定用户
	 * @param title 消息标题
	 * @param message 消息内容
	 * @param data 业务数据
	 * @param userId 指定的用户ID（别名）
	 * @return 推送结果
	 */
	PushResult pushToAndroidUser(String title, String message, Map<String, Object> data, String... userId);
	
	/**
	 * 推送给IOS平台所有用户
	 * @param title 消息标题
	 * @param message 消息内容
	 * @return 推送结果
	 */
	PushResult pushToIos(String title, String message);
	
	/**
	 * 推送给IOS平台所有用户
	 * @param title 消息标题
	 * @param message 消息内容
	 * @param data 业务数据
	 * @return 推送结果
	 */
	PushResult pushToIos(String title, String message, Map<String, Object> data);
	
	/**
	 * 推送给IOS平台指定用户
	 * @param title 消息标题
	 * @param message 消息内容
	 * @param userId 指定的用户ID（别名）
	 * @return 推送结果
	 */
	PushResult pushToIosUser(String title, String message, String... userId);
	
	/**
	 * 推送给IOS平台指定用户
	 * @param title 消息标题
	 * @param message 消息内容
	 * @param data 业务数据
	 * @param userId 指定的用户ID（别名）
	 * @return 推送结果
	 */
	PushResult pushToIosUser(String title, String message, Map<String, Object> data, String... userId);
	
}
