/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.captcha.impl;

import cn.zhxu.toys.captcha.Captcha;
import cn.zhxu.toys.captcha.CaptchaAttrs;
import cn.zhxu.toys.captcha.CaptchaException;
import cn.zhxu.toys.captcha.CaptchaManager;
import cn.zhxu.toys.captcha.CaptchaService;
import cn.zhxu.toys.captcha.CodeGenerator;
import cn.zhxu.toys.captcha.CodeRenderer;
import cn.zhxu.toys.captcha.impl.RandomCharCodeGenerator;
import org.springframework.beans.factory.InitializingBean;

public class BaseCaptchaManager
implements CaptchaManager,
InitializingBean {
    public static final String ATTR_EXPIRE_SECONDS = "expireSeconds";
    private CodeGenerator codeGenerator;
    private CodeRenderer codeRenderer;
    private CaptchaService captchaService;
    private int expireSeconds = 300;

    @Override
    public void genAndRender(String captchaId, CaptchaAttrs attrs) throws CaptchaException {
        CodeGenerator.CodeResult result = this.codeGenerator.generate();
        this.codeRenderer.render(result.getCode(), attrs);
        Integer expireSeconds = attrs.get(ATTR_EXPIRE_SECONDS, Integer.class, this.expireSeconds);
        this.captchaService.save(captchaId, result.getCheck(), expireSeconds);
    }

    @Override
    public CaptchaManager.VerifyResult verify(String captchaId, String code) {
        if (code == null) {
            return CaptchaManager.VerifyResult.INVALID;
        }
        Captcha captcha = this.captchaService.findCaptcha(captchaId);
        if (captcha == null) {
            return CaptchaManager.VerifyResult.INVALID;
        }
        if (captcha.isExpired()) {
            return CaptchaManager.VerifyResult.EXPIRED;
        }
        if (code.equals(captcha.getCode())) {
            this.captchaService.delete(captchaId);
            return CaptchaManager.VerifyResult.SUCCESS;
        }
        return CaptchaManager.VerifyResult.INVALID;
    }

    public void afterPropertiesSet() {
        if (this.captchaService == null) {
            throw new IllegalStateException("You must set a captchaService into CaptchaManager");
        }
        if (this.codeRenderer == null) {
            throw new IllegalStateException("You must set a codeRenderer into CaptchaManager");
        }
        if (this.codeGenerator == null) {
            this.codeGenerator = new RandomCharCodeGenerator();
        }
    }

    public CodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    public void setCodeGenerator(CodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
    }

    public CodeRenderer getCodeRenderer() {
        return this.codeRenderer;
    }

    public void setCodeRenderer(CodeRenderer codeRenderer) {
        this.codeRenderer = codeRenderer;
    }

    public CaptchaService getCaptchaService() {
        return this.captchaService;
    }

    public void setCaptchaService(CaptchaService captchaService) {
        this.captchaService = captchaService;
    }

    public int getExpireSeconds() {
        return this.expireSeconds;
    }

    public void setExpireSeconds(int expireSeconds) {
        this.expireSeconds = expireSeconds;
    }
}

