/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.captcha.impl;

import cn.zhxu.toys.cache.CacheService;
import cn.zhxu.toys.captcha.Captcha;
import cn.zhxu.toys.captcha.CaptchaService;
import cn.zhxu.toys.captcha.impl.CaptchaBean;

public class DefaultCaptchaService
implements CaptchaService {
    private String keyPrefix = "captcha";
    private CacheService cacheService;
    private int cacheSeconds = 1800;

    public DefaultCaptchaService() {
    }

    public DefaultCaptchaService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Override
    public Captcha findCaptcha(String captchaId) {
        return this.cacheService.cache(this.key(captchaId), CaptchaBean.class);
    }

    @Override
    public void save(String captchaId, String code, int expireSeconds) {
        CaptchaBean captcha = new CaptchaBean();
        captcha.setCode(code);
        captcha.setExpireTime(System.currentTimeMillis() / 1000L + (long)expireSeconds);
        this.cacheService.cache(this.key(captchaId), this.cacheSeconds, captcha);
    }

    @Override
    public void delete(String captchaId) {
        this.cacheService.delete(this.key(captchaId));
    }

    private String key(String captchaId) {
        return this.keyPrefix + ":" + captchaId;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public CacheService getCacheService() {
        return this.cacheService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public int getCacheSeconds() {
        return this.cacheSeconds;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheSeconds = cacheSeconds;
    }
}

