/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.msg;

import cn.zhxu.toys.cache.CacheService;
import cn.zhxu.toys.msg.MsgSender;
import cn.zhxu.toys.msg.ReqIpGetter;
import cn.zhxu.toys.util.StringUtils;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPChkMsgSender
implements MsgSender {
    private static final Logger log = LoggerFactory.getLogger(IPChkMsgSender.class);
    private MsgSender msgSender;
    private ReqIpGetter reqIpGetter;
    private CacheService cacheService;
    private String cachePrefix = "msgSender";
    private List<String> whiteIpList;
    private int maxAllowCountPerDay = 50;
    private long countCycleSeconds = 86400L;
    private int redisExpireSeconds = 172800;
    private int minSendInterval = 5;

    @Override
    public boolean send(String phone, String tmplName, String ... tmplArgs) {
        String ip = this.reqIpGetter.getIp();
        if (StringUtils.isBlank(ip)) {
            log.warn("\u62d2\u7edd\u53d1\u9001 [phone: " + phone + ", tmplName: " + tmplName + ", IP: " + ip + "]");
            return false;
        }
        if (this.getWhiteIpList().contains(ip)) {
            log.info("\u53d1\u9001\u77ed\u4fe1 [phone: " + phone + ", tmplName: " + tmplName + ", IP: " + ip + "]");
            return this.msgSender.send(phone, tmplName, tmplArgs);
        }
        String cacheKey = this.cachePrefix + ":" + ip + ":" + tmplName;
        CacheItem item = this.cacheService.cache(cacheKey, CacheItem.class);
        long now = System.currentTimeMillis() / 1000L;
        if (item != null) {
            long timeDiff = now - item.getLastSentTime();
            if (timeDiff < (long)this.minSendInterval) {
                log.warn("\u62d2\u7edd\u53d1\u9001 [phone: " + phone + ", tmplName: " + tmplName + ", IP: " + ip + "]: \u8bf7\u6c42\u8fc7\u4e8e\u9891\u7e41\uff1a" + timeDiff);
                return false;
            }
            if (item.getCountTime() < now - this.countCycleSeconds) {
                item.setCount(0);
                item.setCountTime(now);
            }
            if (item.getCount() >= this.maxAllowCountPerDay) {
                log.warn("\u62d2\u7edd\u53d1\u9001 [phone: " + phone + ", tmplName: " + tmplName + ", IP: " + ip + "]: \u6700\u5927\u6761\u6570\u9650\u5236\uff1a[sent: " + item.getCount() + ", maxAllow: " + this.maxAllowCountPerDay + "]");
                return false;
            }
        }
        log.info("\u53d1\u9001\u77ed\u4fe1 [phone: " + phone + ", tmplName: " + tmplName + ", IP: " + ip + "]");
        boolean success = this.msgSender.send(phone, tmplName, tmplArgs);
        if (success) {
            if (item == null) {
                item = new CacheItem();
                item.setCountTime(now);
            }
            item.setLastSentTime(now);
            item.setCount(item.getCount() + 1);
            this.cacheService.cache(cacheKey, this.redisExpireSeconds, item);
        }
        return success;
    }

    public MsgSender getMsgSender() {
        return this.msgSender;
    }

    public void setMsgSender(MsgSender msgSender) {
        this.msgSender = msgSender;
    }

    public ReqIpGetter getReqIpGetter() {
        return this.reqIpGetter;
    }

    public void setReqIpGetter(ReqIpGetter reqIpGetter) {
        this.reqIpGetter = reqIpGetter;
    }

    public CacheService getCacheService() {
        return this.cacheService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public String getCachePrefix() {
        return this.cachePrefix;
    }

    public void setCachePrefix(String cachePrefix) {
        this.cachePrefix = cachePrefix;
    }

    public int getMaxAllowCountPerDay() {
        return this.maxAllowCountPerDay;
    }

    public void setMaxAllowCountPerDay(int maxAllowCountPerDay) {
        this.maxAllowCountPerDay = maxAllowCountPerDay;
    }

    public long getCountCycleSeconds() {
        return this.countCycleSeconds;
    }

    public void setCountCycleSeconds(long countCycleSeconds) {
        this.countCycleSeconds = countCycleSeconds;
    }

    public int getRedisExpireSeconds() {
        return this.redisExpireSeconds;
    }

    public void setRedisExpireSeconds(int redisExpireSeconds) {
        this.redisExpireSeconds = redisExpireSeconds;
    }

    public int getMinSendInterval() {
        return this.minSendInterval;
    }

    public void setMinSendInterval(int minSendInterval) {
        this.minSendInterval = minSendInterval;
    }

    public List<String> getWhiteIpList() {
        return this.whiteIpList != null ? this.whiteIpList : Collections.emptyList();
    }

    public void setWhiteIpList(List<String> whiteIpList) {
        this.whiteIpList = whiteIpList;
    }

    public static class CacheItem {
        private int count;
        private long lastSentTime;
        private long countTime;

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public long getLastSentTime() {
            return this.lastSentTime;
        }

        public void setLastSentTime(long lastSentTime) {
            this.lastSentTime = lastSentTime;
        }

        public long getCountTime() {
            return this.countTime;
        }

        public void setCountTime(long countTime) {
            this.countTime = countTime;
        }
    }
}

