/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.msg;

import cn.zhxu.toys.msg.AbstractMsgSender;
import cn.zhxu.toys.msg.MsgTemplate;
import com.ejlchina.data.Mapper;
import com.ejlchina.okhttps.HttpResult;
import com.ejlchina.okhttps.HttpUtils;
import com.ejlchina.okhttps.SHttpTask;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WoDongMsgSender
extends AbstractMsgSender {
    static Logger log = LoggerFactory.getLogger(WoDongMsgSender.class);
    public static String DEFAULT_ENDPOINT = "https://client.movek.net:8443/sendvarsms.aspx";
    private String endpoint = DEFAULT_ENDPOINT;
    private String userId;
    private String account;
    private String password;

    @Override
    public void init(Map<String, String> params) throws AbstractMsgSender.MsgSenderInitException {
        String endpoint = params.get("endpoint");
        String userId = params.get("userId");
        String account = params.get("account");
        String password = params.get("password");
        if (userId == null) {
            throw new AbstractMsgSender.MsgSenderInitException("\u7f3a\u5c11\u53c2\u6570\uff1auserId");
        }
        if (account == null) {
            throw new AbstractMsgSender.MsgSenderInitException("\u7f3a\u5c11\u53c2\u6570\uff1aaccount");
        }
        if (password == null) {
            throw new AbstractMsgSender.MsgSenderInitException("\u7f3a\u5c11\u53c2\u6570\uff1apassword");
        }
        if (endpoint != null) {
            this.endpoint = endpoint;
        }
        this.userId = userId;
        this.account = account;
        this.password = password;
    }

    @Override
    public boolean send(String phone, MsgTemplate template, String ... tmplArgs) {
        String content = template.getTmplValue();
        if (tmplArgs != null) {
            Object[] argNames = template.getTmplArgs();
            if (tmplArgs.length > 0 && (argNames == null || argNames.length < tmplArgs.length)) {
                throw new RuntimeException("WoDongMsgTemplate tmplArgs not match: " + Arrays.toString(argNames) + " to " + Arrays.toString(tmplArgs));
            }
            for (int index = 0; index < tmplArgs.length; ++index) {
                String placeHolder = "${" + (String)argNames[index] + "}";
                content = content.replace(placeHolder, tmplArgs[index]);
            }
        }
        try {
            content = URLEncoder.encode(content, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "send");
        params.put("userid", this.userId);
        params.put("account", this.account);
        params.put("password", this.password);
        params.put("mobile", phone);
        params.put("content", content);
        params.put("json", "1");
        try {
            return this.send(phone, params);
        }
        catch (Exception e) {
            throw new RuntimeException("\u805a\u5408\u4fe1\u606f\u53d1\u9001\u5f02\u5e38\uff1a", e);
        }
    }

    private boolean send(String phone, Map<String, String> params) throws Exception {
        log.info("send params [" + phone + "] = " + params);
        HttpResult result = ((SHttpTask)HttpUtils.sync((String)this.endpoint).addBodyPara(params)).post();
        if (!result.isSuccessful()) {
            log.error("\u6c83\u52a8\u77ed\u4fe1\u8fd4\u56de\u72b6\u6001\u7801\u9519\u8bef\uff1a" + result.getStatus());
            return false;
        }
        Mapper json = result.getBody().toMapper();
        String code = json.getString("code");
        if (code != null && code.toLowerCase().equals("success")) {
            return true;
        }
        log.error("\u53d1\u9001\u4fe1\u606f\u4e0d\u6210\u529f\uff1a " + json);
        return false;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

