/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.push;

import cn.jiguang.common.ClientConfig;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.Notification;
import cn.zhxu.toys.push.PushException;
import cn.zhxu.toys.push.PushManager;
import cn.zhxu.toys.push.PushResult;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JPushManager
implements PushManager,
InitializingBean,
DisposableBean {
    static Logger log = LoggerFactory.getLogger(JPushManager.class);
    private String appKey;
    private String masterSecret;
    private boolean testing;
    private JPushClient jpushClient = null;

    public void afterPropertiesSet() throws Exception {
        ClientConfig config = ClientConfig.getInstance();
        config.setApnsProduction(!this.testing);
        this.jpushClient = new JPushClient(this.masterSecret, this.appKey, null, config);
    }

    @Override
    public PushResult pushToAll(String title, String message) {
        return this.pushToAll(title, message, null);
    }

    @Override
    public PushResult pushToAll(String title, String message, Map<String, Object> data) {
        Message.Builder builder = Message.newBuilder().setTitle(title).setMsgContent(message);
        if (data != null) {
            data.forEach((key, value) -> builder.addExtra(key, String.valueOf(value)));
        }
        PushPayload.Builder pBuilder = PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.all()).setMessage(builder.build());
        if (title != null) {
            pBuilder.setNotification(Notification.alert((Object)title));
        }
        return this.pushPayload(pBuilder.build());
    }

    @Override
    public PushResult pushToUser(String title, String message, String ... userId) {
        return this.pushToUser(title, message, (Map<String, Object>)null, userId);
    }

    @Override
    public PushResult pushToUser(String title, String message, Map<String, Object> data, String ... userId) {
        Message.Builder builder = Message.newBuilder().setTitle(title).setMsgContent(message);
        if (data != null) {
            data.forEach((key, value) -> builder.addExtra(key, String.valueOf(value)));
        }
        PushPayload.Builder pBuilder = PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.alias((String[])userId)).setMessage(builder.build());
        if (title != null) {
            pBuilder.setNotification(Notification.alert((Object)title));
        }
        return this.pushPayload(pBuilder.build());
    }

    @Override
    public PushResult pushToAndroid(String title, String message) {
        return this.pushToAndroid(title, message, null);
    }

    @Override
    public PushResult pushToAndroid(String title, String message, Map<String, Object> data) {
        Message.Builder builder = Message.newBuilder().setTitle(title).setMsgContent(message);
        if (data != null) {
            data.forEach((key, value) -> builder.addExtra(key, String.valueOf(value)));
        }
        PushPayload.Builder pBuilder = PushPayload.newBuilder().setPlatform(Platform.android()).setAudience(Audience.all()).setMessage(builder.build());
        if (title != null) {
            pBuilder.setNotification(Notification.alert((Object)title));
        }
        return this.pushPayload(pBuilder.build());
    }

    @Override
    public PushResult pushToAndroidUser(String title, String message, String ... userId) {
        return this.pushToAndroidUser(title, message, (Map<String, Object>)null, userId);
    }

    @Override
    public PushResult pushToAndroidUser(String title, String message, Map<String, Object> data, String ... userId) {
        Message.Builder builder = Message.newBuilder().setTitle(title).setMsgContent(message);
        if (data != null) {
            data.forEach((key, value) -> builder.addExtra(key, String.valueOf(value)));
        }
        PushPayload.Builder pBuilder = PushPayload.newBuilder().setPlatform(Platform.android()).setAudience(Audience.alias((String[])userId)).setMessage(builder.build());
        if (title != null) {
            pBuilder.setNotification(Notification.alert((Object)title));
        }
        return this.pushPayload(pBuilder.build());
    }

    @Override
    public PushResult pushToIos(String title, String message) {
        return this.pushToIos(title, message, null);
    }

    @Override
    public PushResult pushToIos(String title, String message, Map<String, Object> data) {
        Message.Builder builder = Message.newBuilder().setTitle(title).setMsgContent(message);
        if (data != null) {
            data.forEach((key, value) -> builder.addExtra(key, String.valueOf(value)));
        }
        PushPayload.Builder pBuilder = PushPayload.newBuilder().setPlatform(Platform.ios()).setAudience(Audience.all()).setMessage(builder.build());
        if (title != null) {
            pBuilder.setNotification(Notification.alert((Object)title));
        }
        return this.pushPayload(pBuilder.build());
    }

    @Override
    public PushResult pushToIosUser(String title, String message, String ... userId) {
        return this.pushToIosUser(title, message, (Map<String, Object>)null, userId);
    }

    @Override
    public PushResult pushToIosUser(String title, String message, Map<String, Object> data, String ... userId) {
        Message.Builder builder = Message.newBuilder().setTitle(title).setMsgContent(message);
        if (data != null) {
            data.forEach((key, value) -> builder.addExtra(key, String.valueOf(value)));
        }
        PushPayload.Builder pBuilder = PushPayload.newBuilder().setPlatform(Platform.ios()).setAudience(Audience.alias((String[])userId)).setMessage(builder.build());
        if (title != null) {
            pBuilder.setNotification(Notification.alert((Object)title));
        }
        return this.pushPayload(pBuilder.build());
    }

    public void destroy() {
        if (this.jpushClient != null) {
            this.jpushClient.close();
        }
    }

    private PushResult pushPayload(PushPayload payload) {
        if (this.jpushClient == null) {
            throw new PushException("Jpush Client \u6ca1\u6709\u5b9e\u4f8b\u5316\uff01");
        }
        try {
            cn.jpush.api.push.PushResult result = this.jpushClient.sendPush(payload);
            String message = result.getOriginalContent();
            if (result.statusCode == 200) {
                return PushResult.success("200", message);
            }
            log.error("\u6781\u5149\u63a8\u9001\u5931\u8d25\uff1a" + message);
            return PushResult.fail(String.valueOf(result.statusCode), message);
        }
        catch (Exception e) {
            throw new PushException("\u6781\u5149\u63a8\u9001\u5f02\u5e38\uff1a", e);
        }
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setMasterSecret(String masterSecret) {
        this.masterSecret = masterSecret;
    }

    public void setTesting(boolean testing) {
        this.testing = testing;
    }
}

