/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DateUtils {
    static final Map<String, ThreadLocal<DateFormat>> POOL = new ConcurrentHashMap<String, ThreadLocal<DateFormat>>();
    static final ThreadLocal<Calendar> CALENDAR_TL = new ThreadLocal();
    public static final String YEAR_PATTERN = "yyyy";
    public static final String MONTH_PATTERN = "yyyy-MM";
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String MILLS_PATTERN = "yyyyMMddHHmmssSSS";

    public static String format(Date date, String pattern) {
        return DateUtils.getFormat(pattern).format(date);
    }

    public static Date parse(String date, String pattern) {
        try {
            return DateUtils.getFormat(pattern).parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790\u7684\u65e5\u671f\u6a21\u5f0f[pattern: " + pattern + ", date: " + date, e);
        }
    }

    public static String formatYear(Date date) {
        return DateUtils.format(date, YEAR_PATTERN);
    }

    public static Date parseYear(String date) {
        return DateUtils.parse(date, YEAR_PATTERN);
    }

    public static String formatMonth(Date date) {
        return DateUtils.format(date, MONTH_PATTERN);
    }

    public static Date parseMonth(String date) {
        return DateUtils.parse(date, MONTH_PATTERN);
    }

    public static String formatDate(Date date) {
        return DateUtils.format(date, DATE_PATTERN);
    }

    public static Date parseDate(String date) {
        return DateUtils.parse(date, DATE_PATTERN);
    }

    public static String formatDateTime(Date date) {
        return DateUtils.format(date, DATETIME_PATTERN);
    }

    public static Date parseDateTime(String date) {
        return DateUtils.parse(date, DATETIME_PATTERN);
    }

    public static String formatMills(Date date) {
        return DateUtils.format(date, MILLS_PATTERN);
    }

    public static Date parseMills(String date) {
        return DateUtils.parse(date, MILLS_PATTERN);
    }

    public static Date dateCeil(Date date) {
        Calendar calendar = DateUtils.getCalendar();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    public static Date dateFloor(Date date) {
        Calendar calendar = DateUtils.getCalendar();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date dateAdd(Date date, int years, int months, int days) {
        Calendar calendar = DateUtils.getCalendar();
        calendar.setTime(date);
        calendar.add(1, years);
        calendar.add(2, months);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static Date addYears(Date date, int years) {
        return DateUtils.dateAdd(date, years, 0, 0);
    }

    public static Date addMonths(Date date, int months) {
        return DateUtils.dateAdd(date, 0, months, 0);
    }

    public static Date addDays(Date date, int days) {
        return DateUtils.dateAdd(date, 0, 0, days);
    }

    public static Date nextDay(Date date) {
        return DateUtils.addDays(date, 1);
    }

    public static Date prevDay(Date date) {
        return DateUtils.addDays(date, -1);
    }

    public static Date timeAdd(Date date, int hours, int minutes, int seconds, int millis) {
        Calendar calendar = DateUtils.getCalendar();
        calendar.setTime(date);
        calendar.add(11, hours);
        calendar.add(12, minutes);
        calendar.add(13, seconds);
        calendar.add(14, millis);
        return calendar.getTime();
    }

    public static Date addHours(Date date, int hours) {
        return DateUtils.timeAdd(date, hours, 0, 0, 0);
    }

    public static Date addMinutes(Date date, int minutes) {
        return DateUtils.timeAdd(date, 0, minutes, 0, 0);
    }

    public static Date addSeconds(Date date, int seconds) {
        return DateUtils.timeAdd(date, 0, 0, seconds, 0);
    }

    public static int daysOfMonth(String month) {
        return DateUtils.daysOfMonth(DateUtils.parseMonth(month));
    }

    public static int daysOfMonth(Date month) {
        Calendar calendar = DateUtils.getCalendar();
        calendar.setTime(month);
        return calendar.getActualMaximum(5);
    }

    public static int daysOfYear(String year) {
        return DateUtils.daysOfYear(DateUtils.parseYear(year));
    }

    public static int daysOfYear(Date year) {
        Calendar calendar = DateUtils.getCalendar();
        calendar.setTime(year);
        return calendar.getActualMaximum(6);
    }

    public static Date todayBeginning() {
        Calendar calendar = DateUtils.getCalendar();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static boolean isMonthBeginning(Date date) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        return cal.get(5) == 1;
    }

    public static boolean isMonthEnding(Date date) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        cal.add(5, 1);
        return cal.get(5) == 1;
    }

    public static boolean isYearBeginning(Date date) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        return cal.get(6) == 1;
    }

    public static boolean isYearEnding(Date date) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        cal.add(6, 1);
        return cal.get(6) == 1;
    }

    public static Date min(Date ... dates) {
        if (dates.length == 0) {
            return null;
        }
        Date m = dates[0];
        for (int i = 1; i < dates.length; ++i) {
            if (m.getTime() <= dates[i].getTime()) continue;
            m = dates[i];
        }
        return m;
    }

    public static Date max(Date ... dates) {
        if (dates.length == 0) {
            return null;
        }
        Date m = dates[0];
        for (int i = 1; i < dates.length; ++i) {
            if (m.getTime() >= dates[i].getTime()) continue;
            m = dates[i];
        }
        return m;
    }

    public static int yearOf(Date date) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int monthOf(Date date) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        return cal.get(2);
    }

    public static int dayOfYear(Date date) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        return cal.get(6);
    }

    public static int dayOfMonth(Date date) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int dayOfWeek(Date date) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        return cal.get(7);
    }

    public static int weekOfYear(Date date) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        return cal.get(3);
    }

    public static int weekOfMonth(Date date) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        return cal.get(4);
    }

    private static Calendar getCalendar() {
        Calendar cal = CALENDAR_TL.get();
        if (cal == null) {
            cal = Calendar.getInstance();
            CALENDAR_TL.set(cal);
        }
        return cal;
    }

    private static DateFormat getFormat(String pattern) {
        DateFormat sdf;
        ThreadLocal<DateFormat> local = POOL.get(pattern);
        if (local == null) {
            local = new ThreadLocal();
            POOL.put(pattern, local);
        }
        if ((sdf = local.get()) == null) {
            sdf = new SimpleDateFormat(pattern);
            local.set(sdf);
        }
        return sdf;
    }
}

