package cn.zhxu.toys.push;

import cn.zhxu.xjson.JsonKit;
import cn.zhxu.toys.util.DigestUtils;
import cn.zhxu.toys.util.StringUtils;
import com.ejlchina.okhttps.HttpResult;
import com.ejlchina.okhttps.HttpUtils;
import com.ejlchina.okhttps.OkHttps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * 
 * 友盟推送管理器
 * 
 * @author Troy.Zhou
 *
 */
public class UPushManager implements PushManager {

	static Logger log = LoggerFactory.getLogger(UPushManager.class);
	
	/**
	 * Android设备表示走系统通道时打开指定页面acitivity的完整包路径
	 */
	public static String DATA_KEY__ACTIVITY = "com.ejlchina.common.push.UPushManager.DATA_KEY__ACTIVITY";
	
	/**
	 * IOS应用角标
	 */
	public static String DATA_KEY__BADGE = "com.ejlchina.common.push.UPushManager.DATA_KEY__BADGE";
	
	
	private String endpoint = "https://msgapi.umeng.com/api/send";
	
	private String androidAppKey;
	private String androidMasterSecret;
	
	private String iosAppKey;
	private String iosMasterSecret;
	
	private boolean testing;
	
	// Android设备表示走系统通道时打开指定页面acitivity的完整包路径
	private String activity;
	
	
	@Override
	public PushResult pushToAll(String title, String message) {
		return pushToAll(title, message, null);
	}

	@Override
	public PushResult pushToAll(String title, String message, Map<String, Object> data) {
		return pushToUser(title, message, data);
	}
	
	@Override
	public PushResult pushToUser(String title, String message, String... userId) {
		return pushToUser(title, message, null, userId);
	}

	@Override
	public PushResult pushToUser(String title, String message, Map<String, Object> data, String... userId) {
		PushResult result1 = pushToAndroidUser(title, message, data, userId);
		PushResult result2 = pushToIosUser(title, message, data, userId);
		String errcode = result1.getCode() + "-" + result2.getCode();
		String errmsg = result1.getMessage() + "-" + result2.getMessage();
		if (result1.isSuccess() && result2.isSuccess()) {
			return PushResult.success(errcode, errmsg);
		}
		return PushResult.fail(errcode, errmsg);
	}
	
	@Override
	public PushResult pushToAndroid(String title, String message) {
		return pushToAndroid(title, message, null);
	}
	
	@Override
	public PushResult pushToAndroid(String title, String message, Map<String, Object> data) {
		return pushToAndroidUser(title, message, data);
	}
	
	@Override
	public PushResult pushToAndroidUser(String title, String message, String... userId) {
		return pushToAndroidUser(title, message, null, userId);
	}

	@Override
	public PushResult pushToAndroidUser(String title, String message, Map<String, Object> data, String... userId) {
		Map<String, Object> body = new HashMap<>();
		body.put("title", title);
		body.put("ticker", title);
		body.put("text", message);
		String miActivity = null;
		if (data != null) {
			miActivity = (String) data.remove(DATA_KEY__ACTIVITY);
			body.put("custom", data);
		}
		Map<String, Object> payload = new HashMap<>();
		payload.put("display_type", title != null ? "notification": "message");
		payload.put("body", body);
		Map<String, Object> json = new HashMap<>();
		json.put("payload", payload);
		if (miActivity != null) {
			json.put("mipush", "true");
			json.put("mi_activity", miActivity);
		} else if (activity != null) {
			json.put("mipush", "true");
			json.put("mi_activity", activity);
		}
		return requestPush(json, true, userId);
	}

	
	@Override
	public PushResult pushToIos(String title, String message) {
		return pushToIos(title, message, null);
	}

	
	@Override
	public PushResult pushToIos(String title, String message, Map<String, Object> data) {
		return pushToIosUser(title, message, data);
	}
	
	@Override
	public PushResult pushToIosUser(String title, String message, String... userId) {
		return pushToIosUser(title, message, null, userId);
	}
	
	
	@Override
	public PushResult pushToIosUser(String title, String message, Map<String, Object> data, String... userId) {
		Map<String, Object> alert = new HashMap<>();
		alert.put("title", title);
		alert.put("body", message);
		Map<String, Object> body = new HashMap<>();
		body.put("alert", alert);
		if (data != null) {
			Object badge = data.remove(DATA_KEY__BADGE);
			if (badge != null) {
				body.put("badge", badge);
			}
		}
		Map<String, Object> payload = new HashMap<>();
		payload.put("aps", body);
		if (data != null) {
			payload.putAll(data);
		}
		Map<String, Object> json = new HashMap<>();
		json.put("payload", payload);
		if (userId != null && userId.length > 0) {
			json.put("alias_type", "ios");
		}
		return requestPush(json, false, userId);
	}



	protected PushResult requestPush(Map<String, Object> json, boolean android, String... userId) {
		if (userId != null && userId.length > 0) {
			json.put("type", "customizedcast");
			json.put("alias_type", android ? "android" : "ios");
			json.put("alias", StringUtils.join(userId, ","));
		} else {
			json.put("type", "broadcast");
		}
		json.put("appkey", android ? androidAppKey : iosAppKey);
		json.put("timestamp", System.currentTimeMillis());
		json.put("production_mode", String.valueOf(!testing));
		String payload = JsonKit.toJson(json);
		String signSource = "POST" + endpoint + payload + (android ? androidMasterSecret : iosMasterSecret);
		String sign = DigestUtils.toMd5(signSource);
		HttpResult result = HttpUtils.sync(endpoint)
				.addUrlPara("sign", sign)
				.bodyType(OkHttps.JSON)
				.setBodyPara(payload)
				.post();
		String code = String.valueOf(result.getStatus());
		String message = result.getBody().toString();
		if (result.isSuccessful()) {
			return PushResult.success(code, message);
		}
		log.error("友盟推送失败：" + message);
		return PushResult.fail(code, message);
	}
	
	
	
	public String getEndpoint() {
		return endpoint;
	}

	public void setEndpoint(String endpoint) {
		this.endpoint = endpoint;
	}

	public String getAndroidAppKey() {
		return androidAppKey;
	}

	public void setAndroidAppKey(String androidAppKey) {
		this.androidAppKey = androidAppKey;
	}

	public String getAndroidMasterSecret() {
		return androidMasterSecret;
	}

	public void setAndroidMasterSecret(String androidMasterSecret) {
		this.androidMasterSecret = androidMasterSecret;
	}

	public String getIosAppKey() {
		return iosAppKey;
	}

	public void setIosAppKey(String iosAppKey) {
		this.iosAppKey = iosAppKey;
	}

	public String getIosMasterSecret() {
		return iosMasterSecret;
	}

	public void setIosMasterSecret(String iosMasterSecret) {
		this.iosMasterSecret = iosMasterSecret;
	}
	
	public boolean isTesting() {
		return testing;
	}

	public void setTesting(boolean testing) {
		this.testing = testing;
	}

	public String getActivity() {
		return activity;
	}

	public void setActivity(String activity) {
		this.activity = activity;
	}

}

