/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.cache;

import cn.zhxu.toys.cache.AbstractCacheService;
import cn.zhxu.toys.cache.CacheGetter;
import java.lang.reflect.Type;
import java.util.List;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisCacheService
extends AbstractCacheService {
    private JedisPool jedisPool;

    public RedisCacheService() {
    }

    public RedisCacheService(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public void delete(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.del(key);
        }
    }

    @Override
    public void cache(String key, int timeoutSeconds, Object object) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.setex(key, (long)timeoutSeconds, this.toString(object));
        }
    }

    @Override
    protected <T> T doCache(String key, int timeoutSeconds, Type resType, CacheGetter<T> getter) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String cache = jedis.get(key);
            if (cache != null) {
                Object t = this.toBean(cache, resType);
                return t;
            }
        }
        if (timeoutSeconds > 0 && getter != null) {
            T object = getter.doGet();
            this.cache(key, timeoutSeconds, object);
            return object;
        }
        return null;
    }

    @Override
    protected <T> List<T> doCacheList(String key, int timeoutSeconds, Class<T> resType, CacheGetter<List<T>> getter) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String cache = jedis.get(key);
            if (cache != null) {
                List<T> list = this.toList(cache, resType);
                return list;
            }
        }
        if (timeoutSeconds > 0 && getter != null) {
            List<T> list = getter.doGet();
            this.cache(key, timeoutSeconds, list);
            return list;
        }
        return null;
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }
}

