/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.concurrent;

import cn.zhxu.toys.concurrent.BloomFilter;

public abstract class AbstractBloomFilter
implements BloomFilter {
    private BloomFilter.Hasher hasher;
    private final long bitArrLength;
    private final int hashFunCount;

    public AbstractBloomFilter(int expectedInsertions, double fpp) {
        this(null, expectedInsertions, fpp);
    }

    public AbstractBloomFilter(BloomFilter.Hasher hasher, int expectedInsertions, double fpp) {
        if (expectedInsertions < 1) {
            throw new IllegalArgumentException("expectedInsertions must greater than 0");
        }
        if (fpp <= 0.0 || fpp >= 1.0) {
            throw new IllegalArgumentException("fpp must greater than 0 and less than 1");
        }
        this.hasher = hasher;
        this.bitArrLength = AbstractBloomFilter.optimalNumOfBits(expectedInsertions, fpp);
        this.hashFunCount = AbstractBloomFilter.optimalNumOfHashFunctions(expectedInsertions, this.bitArrLength);
    }

    @Override
    public void put(String key, Object object) {
        long[] positions = new long[this.hashFunCount];
        for (int i = 0; i < this.hashFunCount; ++i) {
            long hash = this.hasher.hash(object, i);
            positions[i] = hash % this.bitArrLength;
        }
        this.updateBitArray(key, positions);
    }

    @Override
    public boolean mightContain(String key, Object object) {
        long[] positions = new long[this.hashFunCount];
        for (int i = 0; i < this.hashFunCount; ++i) {
            long hash = this.hasher.hash(object, i);
            positions[i] = hash % this.bitArrLength;
        }
        return this.checkBitArray(key, positions);
    }

    public abstract void updateBitArray(String var1, long[] var2);

    public abstract boolean checkBitArray(String var1, long[] var2);

    protected static long optimalNumOfBits(long n, double p) {
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return (long)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    protected static int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)m / (double)n * Math.log(2.0)));
    }

    public BloomFilter.Hasher getHasher() {
        return this.hasher;
    }

    public void setHasher(BloomFilter.Hasher hasher) {
        this.hasher = hasher;
    }
}

