/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.concurrent;

import cn.zhxu.toys.concurrent.LockException;
import cn.zhxu.toys.concurrent.SyncLock;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSyncLock
implements SyncLock {
    static Logger log = LoggerFactory.getLogger(AbstractSyncLock.class);
    private String keyPrefix = "lock";
    private String nodeId;
    private int maxHoldSeconds = 15;
    private int maxWaitSeconds = 30;
    private int retryInterval = 50;

    @Override
    public void lock(String name) {
        this.lock(name, this.getRequestId(), this.maxHoldSeconds, this.maxWaitSeconds);
    }

    @Override
    public void lock(String name, int maxHoldSeconds) {
        this.lock(name, this.getRequestId(), maxHoldSeconds, this.maxWaitSeconds);
    }

    @Override
    public void lock(String name, int maxHoldSeconds, int maxWaitSeconds) {
        this.lock(name, this.getRequestId(), maxHoldSeconds, maxWaitSeconds);
    }

    @Override
    public void lock(String name, String requestId) {
        this.lock(name, requestId, this.maxHoldSeconds, this.maxWaitSeconds);
    }

    @Override
    public void lock(String name, String requestId, int maxHoldSeconds) {
        this.lock(name, requestId, maxHoldSeconds, this.maxWaitSeconds);
    }

    @Override
    public void lock(String name, String requestId, int maxHoldSeconds, int maxWaitSeconds) {
        String key = this.getLockKey(name);
        long ts = System.nanoTime() / 1000000L;
        while (!this.doTryLock(key, requestId, maxHoldSeconds)) {
            long tn = System.nanoTime() / 1000000L;
            if (tn - ts > (long)(maxWaitSeconds * 1000)) {
                throw new LockException("\u83b7\u53d6\u9501\u7b49\u5f85\u8d85\u65f6\uff01\u3010name\uff1a" + name + "requestId\uff1a" + requestId + "\u3011\u6700\u5927\u5141\u8bb8\uff1a" + maxWaitSeconds + "\u79d2\uff0c\u5df2\u7528\u65f6\u95f4\uff1a" + (tn - ts) / 1000L + "\u79d2\uff01");
            }
            if (this.retryInterval <= 0) continue;
            try {
                Thread.sleep(this.retryInterval);
            }
            catch (InterruptedException e) {
                throw new LockException("Interrupted", e);
            }
        }
        return;
    }

    protected abstract boolean doTryLock(String var1, String var2, int var3);

    @Override
    public void release(String name) {
        this.release(name, this.getRequestId());
    }

    @Override
    public void release(String name, String requestId) {
        this.doUnLock(this.getLockKey(name), requestId);
    }

    protected abstract void doUnLock(String var1, String var2);

    @Override
    public void with(String name, Runnable run) {
        this.with(name, this.getRequestId(), this.maxHoldSeconds, this.maxWaitSeconds, run);
    }

    @Override
    public void with(String name, int maxHoldSeconds, Runnable run) {
        this.with(name, this.getRequestId(), maxHoldSeconds, this.maxWaitSeconds, run);
    }

    @Override
    public void with(String name, int maxHoldSeconds, int maxWaitSeconds, Runnable run) {
        this.with(name, this.getRequestId(), maxHoldSeconds, maxWaitSeconds, run);
    }

    @Override
    public void with(String name, String requestId, Runnable run) {
        this.with(name, requestId, this.maxHoldSeconds, this.maxWaitSeconds, run);
    }

    @Override
    public void with(String name, String requestId, int maxHoldSeconds, Runnable run) {
        this.with(name, requestId, maxHoldSeconds, this.maxWaitSeconds, run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void with(String name, String requestId, int maxHoldSeconds, int maxWaitSeconds, Runnable run) {
        this.lock(name, requestId, maxHoldSeconds, maxWaitSeconds);
        try {
            run.run();
        }
        finally {
            this.release(name, requestId);
        }
    }

    @Override
    public <V> V run(String name, Callable<V> run) {
        return this.run(name, this.getRequestId(), this.maxHoldSeconds, this.maxWaitSeconds, run);
    }

    @Override
    public <V> V run(String name, int maxHoldSeconds, Callable<V> run) {
        return this.run(name, this.getRequestId(), maxHoldSeconds, this.maxWaitSeconds, run);
    }

    @Override
    public <V> V run(String name, int maxHoldSeconds, int maxWaitSeconds, Callable<V> run) {
        return this.run(name, this.getRequestId(), maxHoldSeconds, maxWaitSeconds, run);
    }

    @Override
    public <V> V run(String name, String requestId, Callable<V> run) {
        return this.run(name, requestId, this.maxHoldSeconds, this.maxWaitSeconds, run);
    }

    @Override
    public <V> V run(String name, String requestId, int maxHoldSeconds, Callable<V> run) {
        return this.run(name, requestId, maxHoldSeconds, this.maxWaitSeconds, run);
    }

    @Override
    public <V> V run(String name, String requestId, int maxHoldSeconds, int maxWaitSeconds, Callable<V> run) {
        this.lock(name, requestId, maxHoldSeconds, maxWaitSeconds);
        try {
            V v = run.call();
            return v;
        }
        catch (Exception e) {
            throw new LockException("\u9501\u5185\u4e1a\u52a1\u5904\u7406\u5f02\u5e38", e);
        }
        finally {
            this.release(name, requestId);
        }
    }

    protected String getLockKey(String name) {
        return this.keyPrefix + ":" + name;
    }

    protected String getRequestId() {
        long threadId = Thread.currentThread().getId();
        return this.nodeId + ":" + threadId;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public int getMaxHoldSeconds() {
        return this.maxHoldSeconds;
    }

    public void setMaxHoldSeconds(int maxHoldSeconds) {
        this.maxHoldSeconds = maxHoldSeconds;
    }

    public int getMaxWaitSeconds() {
        return this.maxWaitSeconds;
    }

    public void setMaxWaitSeconds(int maxWaitSeconds) {
        this.maxWaitSeconds = maxWaitSeconds;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }
}

