/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.concurrent;

import cn.zhxu.toys.concurrent.AbstractBloomFilter;
import cn.zhxu.toys.concurrent.BloomFilter;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisBloomFilter
extends AbstractBloomFilter {
    private JedisPool jedisPool;
    private String keyPrefix;

    public RedisBloomFilter(int expectedInsertions, double fpp) {
        this((JedisPool)null, expectedInsertions, fpp);
    }

    public RedisBloomFilter(JedisPool jedisPool, int expectedInsertions, double fpp) {
        this(jedisPool, null, expectedInsertions, fpp);
    }

    public RedisBloomFilter(JedisPool jedisPool, BloomFilter.Hasher hasher, int expectedInsertions, double fpp) {
        super(hasher, expectedInsertions, fpp);
        this.jedisPool = jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBitArray(String key, long[] positions) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String key0 = this.key(key);
            for (long pos : positions) {
                jedis.setbit(key0, pos, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkBitArray(String key, long[] positions) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String key0 = this.key(key);
            for (long pos : positions) {
                if (jedis.getbit(key0, pos)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    private String key(String key) {
        return this.keyPrefix + ":" + key;
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }
}

