/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.concurrent;

import cn.zhxu.toys.concurrent.AbstractSyncLock;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.params.SetParams;

public class RedisSyncLock
extends AbstractSyncLock {
    static Logger log = LoggerFactory.getLogger(RedisSyncLock.class);
    private JedisPool jedisPool;

    @Override
    protected boolean doTryLock(String key, String requestId, int maxHoldSeconds) {
        try (Jedis jedis = this.jedisPool.getResource();){
            SetParams params = SetParams.setParams().ex((long)maxHoldSeconds).nx();
            String result = jedis.set(key, requestId, params);
            log.debug("GET_LOCK[" + key + "]: " + result);
            boolean bl = result != null && result.toUpperCase().contains("OK");
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doUnLock(String key, String requestId) {
        try (Jedis jedis = this.jedisPool.getResource();){
            log.debug("DEL_LOCK: " + key);
            String script = "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('del', KEYS[1]) end";
            jedis.eval(script, Collections.singletonList(key), Collections.singletonList(requestId));
        }
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }
}

