/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.oss;

import cn.zhxu.toys.oss.OssManager;

public abstract class AbstractOssManager
implements OssManager {
    protected String endpoint;
    protected Long maxSize = 307200000L;

    protected String resolveFileAccessUrl(String fileKey) {
        return this.getBaseUrl() + fileKey;
    }

    protected String resolveFileKey(String fileAccessUrl) {
        String baseUrl;
        if (fileAccessUrl != null && fileAccessUrl.startsWith(baseUrl = this.getBaseUrl())) {
            return fileAccessUrl.substring(baseUrl.length());
        }
        return null;
    }

    protected String getBaseUrl() {
        String protocol = "http://";
        String host = this.endpoint;
        if (this.endpoint.startsWith("http://")) {
            host = host.substring(7);
        } else if (this.endpoint.startsWith("https://")) {
            host = host.substring(8);
            protocol = "https://";
        }
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        return this.getBaseAccessUrl(protocol, host);
    }

    protected abstract String getBaseAccessUrl(String var1, String var2);

    protected String getContentType(String fileExtension) {
        if (fileExtension != null) {
            String lowerCase = fileExtension.toLowerCase();
            if (".bmp".equals(lowerCase)) {
                return "image/bmp";
            }
            if (".gif".equals(lowerCase)) {
                return "image/gif";
            }
            if (".jpeg".equals(lowerCase) || "jpg".equals(lowerCase) || "png".equals(lowerCase)) {
                return "image/jpeg";
            }
            if (".html".equals(lowerCase)) {
                return "text/html";
            }
            if (".txt".equals(lowerCase)) {
                return "text/plain";
            }
            if (".vsd".equals(lowerCase)) {
                return "application/vnd.visio";
            }
            if (".ppt".equals(lowerCase) || "pptx".equals(lowerCase)) {
                return "application/vnd.ms-powerpoint";
            }
            if (".doc".equals(lowerCase) || "docx".equals(lowerCase)) {
                return "application/msword";
            }
            if (".xml".equals(lowerCase)) {
                return "text/xml";
            }
        }
        return "text/html";
    }

    protected String toExtension(String contentType) {
        return ".*";
    }

    protected String getFileExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf("."));
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Long maxSize) {
        this.maxSize = maxSize;
    }
}

