/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.push;

import cn.zhxu.toys.push.PushManager;
import cn.zhxu.toys.push.PushResult;
import cn.zhxu.toys.util.DigestUtils;
import cn.zhxu.toys.util.StringUtils;
import cn.zhxu.xjson.JsonKit;
import com.ejlchina.okhttps.HttpResult;
import com.ejlchina.okhttps.HttpUtils;
import com.ejlchina.okhttps.SHttpTask;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UPushManager
implements PushManager {
    static Logger log = LoggerFactory.getLogger(UPushManager.class);
    public static String DATA_KEY__ACTIVITY = "com.ejlchina.common.push.UPushManager.DATA_KEY__ACTIVITY";
    public static String DATA_KEY__BADGE = "com.ejlchina.common.push.UPushManager.DATA_KEY__BADGE";
    private String endpoint = "https://msgapi.umeng.com/api/send";
    private String androidAppKey;
    private String androidMasterSecret;
    private String iosAppKey;
    private String iosMasterSecret;
    private boolean testing;
    private String activity;

    @Override
    public PushResult pushToAll(String title, String message) {
        return this.pushToAll(title, message, null);
    }

    @Override
    public PushResult pushToAll(String title, String message, Map<String, Object> data) {
        return this.pushToUser(title, message, data, new String[0]);
    }

    @Override
    public PushResult pushToUser(String title, String message, String ... userId) {
        return this.pushToUser(title, message, (Map<String, Object>)null, userId);
    }

    @Override
    public PushResult pushToUser(String title, String message, Map<String, Object> data, String ... userId) {
        PushResult result1 = this.pushToAndroidUser(title, message, data, userId);
        PushResult result2 = this.pushToIosUser(title, message, data, userId);
        String errcode = result1.getCode() + "-" + result2.getCode();
        String errmsg = result1.getMessage() + "-" + result2.getMessage();
        if (result1.isSuccess() && result2.isSuccess()) {
            return PushResult.success(errcode, errmsg);
        }
        return PushResult.fail(errcode, errmsg);
    }

    @Override
    public PushResult pushToAndroid(String title, String message) {
        return this.pushToAndroid(title, message, null);
    }

    @Override
    public PushResult pushToAndroid(String title, String message, Map<String, Object> data) {
        return this.pushToAndroidUser(title, message, data, new String[0]);
    }

    @Override
    public PushResult pushToAndroidUser(String title, String message, String ... userId) {
        return this.pushToAndroidUser(title, message, (Map<String, Object>)null, userId);
    }

    @Override
    public PushResult pushToAndroidUser(String title, String message, Map<String, Object> data, String ... userId) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", title);
        body.put("ticker", title);
        body.put("text", message);
        String miActivity = null;
        if (data != null) {
            miActivity = (String)data.remove(DATA_KEY__ACTIVITY);
            body.put("custom", data);
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("display_type", title != null ? "notification" : "message");
        payload.put("body", body);
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("payload", payload);
        if (miActivity != null) {
            json.put("mipush", "true");
            json.put("mi_activity", miActivity);
        } else if (this.activity != null) {
            json.put("mipush", "true");
            json.put("mi_activity", this.activity);
        }
        return this.requestPush(json, true, userId);
    }

    @Override
    public PushResult pushToIos(String title, String message) {
        return this.pushToIos(title, message, null);
    }

    @Override
    public PushResult pushToIos(String title, String message, Map<String, Object> data) {
        return this.pushToIosUser(title, message, data, new String[0]);
    }

    @Override
    public PushResult pushToIosUser(String title, String message, String ... userId) {
        return this.pushToIosUser(title, message, (Map<String, Object>)null, userId);
    }

    @Override
    public PushResult pushToIosUser(String title, String message, Map<String, Object> data, String ... userId) {
        Object badge;
        HashMap<String, String> alert = new HashMap<String, String>();
        alert.put("title", title);
        alert.put("body", message);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("alert", alert);
        if (data != null && (badge = data.remove(DATA_KEY__BADGE)) != null) {
            body.put("badge", badge);
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("aps", body);
        if (data != null) {
            payload.putAll(data);
        }
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("payload", payload);
        if (userId != null && userId.length > 0) {
            json.put("alias_type", "ios");
        }
        return this.requestPush(json, false, userId);
    }

    protected PushResult requestPush(Map<String, Object> json, boolean android, String ... userId) {
        if (userId != null && userId.length > 0) {
            json.put("type", "customizedcast");
            json.put("alias_type", android ? "android" : "ios");
            json.put("alias", StringUtils.join(userId, ","));
        } else {
            json.put("type", "broadcast");
        }
        json.put("appkey", android ? this.androidAppKey : this.iosAppKey);
        json.put("timestamp", System.currentTimeMillis());
        json.put("production_mode", String.valueOf(!this.testing));
        String payload = JsonKit.toJson(json);
        String signSource = "POST" + this.endpoint + payload + (android ? this.androidMasterSecret : this.iosMasterSecret);
        String sign = DigestUtils.toMd5(signSource);
        HttpResult result = ((SHttpTask)((SHttpTask)((SHttpTask)HttpUtils.sync((String)this.endpoint).addUrlPara("sign", (Object)sign)).bodyType("json")).setBodyPara((Object)payload)).post();
        String code = String.valueOf(result.getStatus());
        String message = result.getBody().toString();
        if (result.isSuccessful()) {
            return PushResult.success(code, message);
        }
        log.error("\u53cb\u76df\u63a8\u9001\u5931\u8d25\uff1a" + message);
        return PushResult.fail(code, message);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAndroidAppKey() {
        return this.androidAppKey;
    }

    public void setAndroidAppKey(String androidAppKey) {
        this.androidAppKey = androidAppKey;
    }

    public String getAndroidMasterSecret() {
        return this.androidMasterSecret;
    }

    public void setAndroidMasterSecret(String androidMasterSecret) {
        this.androidMasterSecret = androidMasterSecret;
    }

    public String getIosAppKey() {
        return this.iosAppKey;
    }

    public void setIosAppKey(String iosAppKey) {
        this.iosAppKey = iosAppKey;
    }

    public String getIosMasterSecret() {
        return this.iosMasterSecret;
    }

    public void setIosMasterSecret(String iosMasterSecret) {
        this.iosMasterSecret = iosMasterSecret;
    }

    public boolean isTesting() {
        return this.testing;
    }

    public void setTesting(boolean testing) {
        this.testing = testing;
    }

    public String getActivity() {
        return this.activity;
    }

    public void setActivity(String activity) {
        this.activity = activity;
    }
}

