package cn.zhxu.toys.oss;

public abstract class AbstractOssManager implements OssManager {

	protected String endpoint;

	protected Long maxSize = (long) (300000 * 1024);

	protected String resolveFileAccessUrl(String fileKey) {
		return getBaseUrl() + fileKey;
	}

	protected String resolveFileKey(String fileAccessUrl) {
		if (fileAccessUrl != null) {
			String accessUri = uri(fileAccessUrl);
			String baseUri = uri(getBaseUrl());
			if (accessUri.startsWith(baseUri)) {
				return accessUri.substring(baseUri.length());
			}
		}
		return null;
	}

	private String uri(String url) {
		int idx = url.indexOf("://");
		if (idx > 0 && url.length() > idx + 3) {
			return url.substring(idx + 3);
		}
		return url;
	}

	protected String getBaseUrl() {
		String protocol = "https://";
		String host = endpoint;
		if (endpoint.startsWith("http://")) {
			host = host.substring(7);
			protocol = "http://";
		} else if (endpoint.startsWith("https://")) {
			host = host.substring(8);
		}
		if (host.endsWith("/")) {
			host = host.substring(0, host.length() - 1);
		}
		return getBaseAccessUrl(protocol, host);
	}

	protected abstract String getBaseAccessUrl(String protocol, String host);

	protected String getContentType(String fileExtension) {
		if (fileExtension != null) {
			String lowerCase = fileExtension.toLowerCase();
			if (".bmp".equals(lowerCase))
				return "image/bmp";
			if (".gif".equals(lowerCase))
				return "image/gif";
			if (".jpeg".equals(lowerCase) || "jpg".equals(lowerCase) || "png".equals(lowerCase))
				return "image/jpeg";
			if (".html".equals(lowerCase))
				return "text/html";
			if (".txt".equals(lowerCase))
				return "text/plain";
			if (".vsd".equals(lowerCase))
				return "application/vnd.visio";
			if (".ppt".equals(lowerCase) || "pptx".equals(lowerCase))
				return "application/vnd.ms-powerpoint";
			if (".doc".equals(lowerCase) || "docx".equals(lowerCase))
				return "application/msword";
			if (".xml".equals(lowerCase))
				return "text/xml";
		}
		return "text/html";
	}

	protected String toExtension(String contentType) {
		return ".*";
	}

	protected String getFileExtension(String fileName) {
		return fileName.substring(fileName.lastIndexOf("."));
	}

	public String getEndpoint() {
		return endpoint;
	}

	public void setEndpoint(String endpoint) {
		this.endpoint = endpoint;
	}

	public Long getMaxSize() {
		return maxSize;
	}

	public void setMaxSize(Long maxSize) {
		this.maxSize = maxSize;
	}

}
