/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.cache;

import cn.zhxu.data.TypeRef;
import cn.zhxu.toys.cache.CacheGetter;
import cn.zhxu.toys.cache.CacheService;
import cn.zhxu.xjson.JsonKit;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCacheService
implements CacheService {
    private boolean notConvertStrToJson = false;

    @Override
    public <T> T cache(String key, Class<T> resType) {
        return this.cache(key, 0, resType, null);
    }

    @Override
    public <T> T cache(String key, TypeRef<T> resType) {
        return this.cache(key, 0, resType, null);
    }

    @Override
    public <T> T cacheShort(String key, Class<T> resType, CacheGetter<T> getter) {
        return this.cache(key, 3600, resType, getter);
    }

    @Override
    public <T> T cacheShort(String key, TypeRef<T> resType, CacheGetter<T> getter) {
        return this.cache(key, 3600, resType, getter);
    }

    @Override
    public <T> T cacheMedium(String key, Class<T> resType, CacheGetter<T> getter) {
        return this.cache(key, 21600, resType, getter);
    }

    @Override
    public <T> T cacheMedium(String key, TypeRef<T> resType, CacheGetter<T> getter) {
        return this.cache(key, 21600, resType, getter);
    }

    @Override
    public <T> T cacheLong(String key, Class<T> resType, CacheGetter<T> getter) {
        return this.cache(key, 259200, resType, getter);
    }

    @Override
    public <T> T cacheLong(String key, TypeRef<T> resType, CacheGetter<T> getter) {
        return this.cache(key, 259200, resType, getter);
    }

    @Override
    public void cacheShort(String key, Object object) {
        this.cache(key, 3600, object);
    }

    @Override
    public void cacheMedium(String key, Object object) {
        this.cache(key, 21600, object);
    }

    @Override
    public void cacheLong(String key, Object object) {
        this.cache(key, 259200, object);
    }

    @Override
    public <T> T cache(String key, int timeoutSeconds, Class<T> resType, CacheGetter<T> getter) {
        return this.doCache(key, timeoutSeconds, resType, getter);
    }

    @Override
    public <T> T cache(String key, int timeoutSeconds, TypeRef<T> resType, CacheGetter<T> getter) {
        return this.doCache(key, timeoutSeconds, resType.getType(), getter);
    }

    @Override
    public <T> T cacheBean(String key, int timeoutSeconds, Class<T> resType, CacheGetter<T> getter) {
        return this.doCache(key, timeoutSeconds, resType, getter);
    }

    @Override
    public <T> List<T> cacheList(String key, int timeoutSeconds, Class<T> resType, CacheGetter<List<T>> getter) {
        return this.doCacheList(key, timeoutSeconds, resType, getter);
    }

    protected abstract <T> T doCache(String var1, int var2, Type var3, CacheGetter<T> var4);

    protected abstract <T> List<T> doCacheList(String var1, int var2, Class<T> var3, CacheGetter<List<T>> var4);

    protected <T> T toBean(String cache, Type resType) {
        if ("null".equals(cache)) {
            return null;
        }
        if (this.notConvertStrToJson && resType == String.class) {
            return (T)cache;
        }
        return (T)JsonKit.toBean((Type)resType, (String)cache);
    }

    protected <T> List<T> toList(String cache, Class<T> resType) {
        if ("null".equals(cache)) {
            return new ArrayList();
        }
        return JsonKit.toList(resType, (String)cache);
    }

    protected String toString(Object object) {
        if (this.notConvertStrToJson && object instanceof String) {
            return (String)object;
        }
        if (object != null) {
            return JsonKit.toJson((Object)object);
        }
        return "null";
    }

    public boolean isNotConvertStrToJson() {
        return this.notConvertStrToJson;
    }

    public void setNotConvertStrToJson(boolean notConvertStrToJson) {
        this.notConvertStrToJson = notConvertStrToJson;
    }
}

