/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.msg;

import cn.zhxu.toys.msg.MsgSender;
import cn.zhxu.toys.msg.MsgTemplate;
import cn.zhxu.toys.msg.SendResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMsgSender
implements MsgSender {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private List<MsgTemplate> templates;

    public abstract void init(Map<String, String> var1) throws MsgSenderInitException;

    @Override
    public SendResult send(String phone, String tmplName, String ... tmplArgs) {
        MsgTemplate template = this.getMsgTemplate(tmplName);
        if (template == null) {
            throw new RuntimeException("No such MsgTemplate named: " + tmplName);
        }
        return this.send(phone, template, tmplArgs);
    }

    public abstract SendResult send(String var1, MsgTemplate var2, String ... var3);

    public MsgTemplate getMsgTemplate(String tmplName) {
        if (tmplName != null && this.templates != null) {
            for (MsgTemplate template : this.templates) {
                if (!tmplName.equals(template.getName())) continue;
                return template;
            }
        }
        return null;
    }

    public synchronized void addMsgTemplate(MsgTemplate template) {
        if (this.templates == null) {
            this.templates = new ArrayList<MsgTemplate>();
        }
        this.templates.add(template);
    }

    public synchronized void setTemplates(List<MsgTemplate> templates) {
        this.templates = templates;
    }

    public List<MsgTemplate> getTemplates() {
        return this.templates;
    }

    public static class MsgSenderInitException
    extends RuntimeException {
        public MsgSenderInitException(String message) {
            super(message);
        }

        public MsgSenderInitException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

