/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.msg;

import cn.zhxu.toys.msg.AbstractMsgSender;
import cn.zhxu.toys.msg.MsgSender;
import cn.zhxu.toys.msg.MsgTemplate;
import cn.zhxu.toys.msg.SendResult;
import cn.zhxu.toys.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class DynamicMsgSender
implements MsgSender {
    private final Map<Object, AbstractMsgSender> senderPool = new HashMap<Object, AbstractMsgSender>();
    private final Object lock = new Object();
    private Map<String, String[]> templates;
    private RoutingConfigurer routingConfigurer;
    private SenderFactory senderFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendResult send(String phone, String tmplName, String ... tmplArgs) {
        MsgTemplate template;
        AbstractMsgSender sender;
        Object key = this.routingConfigurer.determineCurrentLookupKey();
        Object object = this.lock;
        synchronized (object) {
            sender = this.senderPool.get(key);
            if (sender == null) {
                sender = this.senderFactory.create();
                if (sender == null) {
                    throw new IllegalStateException("the return of MsgSenderFactory#create() can not be null !");
                }
                sender.init(this.routingConfigurer.getInitParams(key));
                this.senderPool.put(key, sender);
            }
            if ((template = sender.getMsgTemplate(tmplName)) == null) {
                String tmplValue = this.routingConfigurer.getTmplValue(key, tmplName);
                if (StringUtils.isBlank(tmplValue)) {
                    throw new IllegalStateException("the return of PlatformSensor#senseMsgTmplValue(" + tmplName + ") is NULL!");
                }
                String[] argsNames = this.templates.get(tmplName);
                if (argsNames == null) {
                    throw new IllegalStateException("No such template named: " + tmplName);
                }
                template = new MsgTemplate(tmplName, tmplValue, argsNames);
                sender.addMsgTemplate(template);
            }
        }
        return sender.send(phone, template, tmplArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPool() {
        Object object = this.lock;
        synchronized (object) {
            this.senderPool.clear();
        }
    }

    public Map<String, String[]> getTemplates() {
        return this.templates;
    }

    public void setTemplates(Map<String, String[]> templates) {
        this.templates = templates;
    }

    public RoutingConfigurer getRoutingConfigurer() {
        return this.routingConfigurer;
    }

    public void setRoutingConfigurer(RoutingConfigurer routingConfigurer) {
        this.routingConfigurer = routingConfigurer;
    }

    public SenderFactory getSenderFactory() {
        return this.senderFactory;
    }

    public void setSenderFactory(SenderFactory senderFactory) {
        this.senderFactory = senderFactory;
    }

    public static interface RoutingConfigurer {
        public Object determineCurrentLookupKey();

        public Map<String, String> getInitParams(Object var1);

        public String getTmplValue(Object var1, String var2);
    }

    public static interface SenderFactory {
        public AbstractMsgSender create();
    }
}

