/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.msg;

import cn.zhxu.data.Mapper;
import cn.zhxu.okhttps.HttpResult;
import cn.zhxu.okhttps.HttpUtils;
import cn.zhxu.okhttps.SHttpTask;
import cn.zhxu.toys.msg.AbstractMsgSender;
import cn.zhxu.toys.msg.MsgTemplate;
import cn.zhxu.toys.msg.SendResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class JuheMsgSender
extends AbstractMsgSender {
    public static String DEFAULT_ENDPOINT = "http://v.juhe.cn/sms/send";
    private String endpoint = DEFAULT_ENDPOINT;
    private String appId;

    @Override
    public void init(Map<String, String> params) {
        String endpoint = params.get("endpoint");
        String appId = params.get("appId");
        if (appId == null) {
            throw new AbstractMsgSender.MsgSenderInitException("\u7f3a\u5c11\u53c2\u6570\uff1aappId");
        }
        if (endpoint != null) {
            this.endpoint = endpoint;
        }
        this.appId = appId;
    }

    @Override
    public SendResult send(String phone, MsgTemplate template, String ... tmplArgs) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mobile", phone);
        params.put("tpl_id", template.getTmplValue());
        params.put("key", this.appId);
        if (tmplArgs != null) {
            Object[] argNames = template.getTmplArgs();
            if (tmplArgs.length > 0 && (argNames == null || argNames.length < tmplArgs.length)) {
                throw new RuntimeException("MsgTemplate tmplArgs not match: " + Arrays.toString(argNames) + " to " + Arrays.toString(tmplArgs));
            }
            StringBuilder sb = new StringBuilder();
            for (int index = 0; index < tmplArgs.length; ++index) {
                sb.append("#").append((String)argNames[index]).append("#=").append(tmplArgs[index]);
                if (index >= tmplArgs.length - 1) continue;
                sb.append("&");
            }
            params.put("tpl_value", sb.toString());
        }
        params.put("dtype", "json");
        try {
            return this.send(phone, params);
        }
        catch (Exception e) {
            throw new RuntimeException("\u805a\u5408\u4fe1\u606f\u53d1\u9001\u5f02\u5e38\uff1a", e);
        }
    }

    private SendResult send(String phone, Map<String, String> params) {
        this.log.info("send params [{}] = {}", (Object)phone, params);
        HttpResult result = ((SHttpTask)HttpUtils.sync((String)this.endpoint).addBodyPara(params)).post();
        if (!result.isSuccessful()) {
            String message = "\u805a\u5408\u77ed\u4fe1\u8fd4\u56de\u72b6\u6001\u7801\u9519\u8bef\uff1a" + result.getStatus();
            this.log.error(message);
            return SendResult.fail(message);
        }
        Mapper json = result.getBody().toMapper();
        if (json.getString("error_code").equals("0")) {
            return SendResult.ok();
        }
        this.log.error("\u53d1\u9001\u4fe1\u606f\u4e0d\u6210\u529f\uff1a{}", (Object)json);
        return SendResult.fail(json.toString());
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }
}

