/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.msg;

import cn.zhxu.toys.cache.CacheService;
import cn.zhxu.toys.msg.KeyResolver;
import cn.zhxu.toys.msg.MsgSender;
import cn.zhxu.toys.msg.RateLimitException;
import cn.zhxu.toys.msg.SendResult;
import cn.zhxu.toys.util.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitMsgSender
implements MsgSender {
    private static final Logger log = LoggerFactory.getLogger(RateLimitMsgSender.class);
    private MsgSender msgSender;
    private KeyResolver keyResolver = phone -> phone;
    private List<String> whiteList = Collections.emptyList();
    private long unitSeconds = 43200L;
    private int maxAllowPerUnit = 30;
    private int minIntervalSeconds = 10;
    private CacheService cacheService;
    private String cachePrefix = "msgSender";
    private int cacheSeconds = 86400;
    private boolean rejectIfKeyBlank = true;
    private boolean errorIfReject = false;

    @Override
    public SendResult send(String phone, String tmplName, String ... tmplArgs) {
        SendResult result;
        if (this.msgSender == null) {
            throw new IllegalStateException("\u60a8\u5fc5\u987b\u4e3a RateLimitMsgSender \u8bbe\u7f6e\u4e00\u4e2a msgSender");
        }
        if (this.cacheService == null) {
            throw new IllegalStateException("\u60a8\u5fc5\u987b\u4e3a RateLimitMsgSender \u8bbe\u7f6e\u4e00\u4e2a cacheService");
        }
        String key = this.keyResolver.revolve(phone);
        if (StringUtils.isBlank(key)) {
            if (this.rejectIfKeyBlank) {
                return this.reject(phone, tmplName, key, "KEY \u4e3a\u7a7a\u767d");
            }
            return this.doSend(key, phone, tmplName, tmplArgs);
        }
        if (this.whiteList.contains(key)) {
            return this.doSend(key, phone, tmplName, tmplArgs);
        }
        String cacheKey = this.cachePrefix + ":" + key + ":" + tmplName;
        CacheItem item = this.cacheService.cache(cacheKey, CacheItem.class);
        long now = System.currentTimeMillis() / 1000L;
        if (item != null) {
            long timeDiff = now - item.getLastSentTime();
            if (timeDiff < (long)this.minIntervalSeconds) {
                return this.reject(phone, tmplName, key, "\u53d1\u9001\u8fc7\u4e8e\u9891\u7e41: " + timeDiff);
            }
            if (item.getCountTime() < now - this.unitSeconds) {
                item.setCount(0);
                item.setCountTime(now);
            }
            if (item.getCount() >= this.maxAllowPerUnit) {
                return this.reject(phone, tmplName, key, "\u5230\u8fbe\u6700\u5927\u53d1\u9001\u6761\u6570: " + this.maxAllowPerUnit);
            }
        }
        if ((result = this.doSend(key, phone, tmplName, tmplArgs)).isOk()) {
            if (item == null) {
                item = new CacheItem();
                item.setCountTime(now);
            }
            item.setLastSentTime(now);
            item.setCount(item.getCount() + 1);
            this.cacheService.cache(cacheKey, this.cacheSeconds, item);
        }
        return result;
    }

    protected SendResult doSend(String key, String phone, String tmplName, String ... tmplArgs) {
        log.info("\u53d1\u9001\u77ed\u4fe1 [phone: " + phone + ", tmplName: " + tmplName + ", key: " + key + "]");
        return this.msgSender.send(phone, tmplName, tmplArgs);
    }

    protected SendResult reject(String phone, String tmplName, String key, String tip) {
        if (this.errorIfReject) {
            throw new RateLimitException(tip);
        }
        String message = "\u62d2\u7edd\u53d1\u9001 [phone: " + phone + ", tmplName: " + tmplName + ", key: " + key + "] " + tip;
        log.warn(message);
        return SendResult.fail(message);
    }

    public MsgSender getMsgSender() {
        return this.msgSender;
    }

    public void setMsgSender(MsgSender msgSender) {
        this.msgSender = msgSender;
    }

    public KeyResolver getKeyResolver() {
        return this.keyResolver;
    }

    public void setKeyResolver(KeyResolver keyResolver) {
        this.keyResolver = Objects.requireNonNull(keyResolver);
    }

    public CacheService getCacheService() {
        return this.cacheService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public String getCachePrefix() {
        return this.cachePrefix;
    }

    public void setCachePrefix(String cachePrefix) {
        this.cachePrefix = cachePrefix;
    }

    public int getMaxAllowPerUnit() {
        return this.maxAllowPerUnit;
    }

    public void setMaxAllowPerUnit(int maxAllowPerUnit) {
        this.maxAllowPerUnit = maxAllowPerUnit;
    }

    public long getUnitSeconds() {
        return this.unitSeconds;
    }

    public void setUnitSeconds(long unitSeconds) {
        this.unitSeconds = unitSeconds;
    }

    public int getCacheSeconds() {
        return this.cacheSeconds;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheSeconds = cacheSeconds;
    }

    public int getMinIntervalSeconds() {
        return this.minIntervalSeconds;
    }

    public void setMinIntervalSeconds(int minIntervalSeconds) {
        this.minIntervalSeconds = minIntervalSeconds;
    }

    public List<String> getWhiteList() {
        return this.whiteList;
    }

    public void setWhiteList(List<String> whiteList) {
        this.whiteList = Objects.requireNonNull(whiteList);
    }

    public boolean isRejectIfKeyBlank() {
        return this.rejectIfKeyBlank;
    }

    public void setRejectIfKeyBlank(boolean rejectIfKeyBlank) {
        this.rejectIfKeyBlank = rejectIfKeyBlank;
    }

    public boolean isErrorIfReject() {
        return this.errorIfReject;
    }

    public void setErrorIfReject(boolean errorIfReject) {
        this.errorIfReject = errorIfReject;
    }

    public static class CacheItem {
        private int count;
        private long lastSentTime;
        private long countTime;

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public long getLastSentTime() {
            return this.lastSentTime;
        }

        public void setLastSentTime(long lastSentTime) {
            this.lastSentTime = lastSentTime;
        }

        public long getCountTime() {
            return this.countTime;
        }

        public void setCountTime(long countTime) {
            this.countTime = countTime;
        }
    }
}

