/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.util;

import java.util.Arrays;

public class NumUtils {
    public static final int RADIX_62 = 62;
    public static final int RADIX_256 = 256;

    public static int from62Num(byte ... data) {
        if (data.length > 5) {
            throw new IllegalArgumentException("the max length is 5 of the data param: " + Arrays.toString(data));
        }
        int sum = 0;
        int scale = 1;
        for (int i = data.length - 1; i >= 0; --i) {
            sum += NumUtils.from62(data[i]) * scale;
            scale *= 62;
        }
        return sum;
    }

    public static boolean not62Num(byte ... data) {
        if (data.length > 5) {
            return true;
        }
        for (byte b : data) {
            if (b >= 48 && b <= 122 && (57 >= b || b >= 65) && (90 >= b || b >= 97)) continue;
            return true;
        }
        return false;
    }

    public static byte[] to62Num(int value, int length) {
        int index;
        if (value < 0) {
            throw new IllegalArgumentException("the value param can not be negative: " + value);
        }
        if (length < 1) {
            throw new IllegalArgumentException("the length param must greater than 0: " + value);
        }
        byte[] bytes = new byte[length];
        for (index = length - 1; value > 0 && index >= 0; value /= 62, --index) {
            byte val;
            bytes[index] = val = NumUtils.to62(value % 62);
        }
        while (index >= 0) {
            bytes[index] = 48;
            --index;
        }
        return bytes;
    }

    public static int unsigned(byte value) {
        if (value >= 0) {
            return value;
        }
        return 256 + value;
    }

    public static int from256Num(byte ... data) {
        if (data.length > 4) {
            throw new IllegalArgumentException("the max length is 4 of the data param: " + Arrays.toString(data));
        }
        int sum = 0;
        int scale = 1;
        for (int i = data.length - 1; i >= 0; --i) {
            sum += NumUtils.unsigned(data[i]) * scale;
            scale <<= 8;
        }
        return sum;
    }

    public static long from256Num(byte[] data, int from, int to) {
        long sum = 0L;
        long scale = 1L;
        for (int i = to - 1; i >= from; --i) {
            sum += (long)NumUtils.unsigned(data[i]) * scale;
            scale <<= 8;
        }
        return sum;
    }

    public static byte[] to256Num(long value, int length) {
        if (value < 0L) {
            throw new IllegalArgumentException("the value param can not be negative: " + value);
        }
        if (length < 1) {
            throw new IllegalArgumentException("the length param must greater than 0: " + value);
        }
        byte[] bytes = new byte[length];
        while (length > 0) {
            bytes[--length] = (byte)(value >> 8 * (bytes.length - length - 1) & 0xFFL);
        }
        return bytes;
    }

    private static int from62(byte b) {
        if (48 <= b && b <= 57) {
            return b - 48;
        }
        if (97 <= b && b <= 122) {
            return b - 87;
        }
        if (65 <= b && b <= 90) {
            return b - 29;
        }
        throw new IllegalArgumentException(b + " is not a num char");
    }

    public static byte to62(int v) {
        if (0 <= v && v <= 9) {
            return (byte)(v + 48);
        }
        if (10 <= v && v <= 35) {
            return (byte)(v + 87);
        }
        if (36 <= v && v <= 61) {
            return (byte)(v + 29);
        }
        throw new IllegalArgumentException(v + " can not cast to 62 Num");
    }
}

