package cn.zhxu.toys.msg;

import cn.zhxu.data.Mapper;
import cn.zhxu.okhttps.HttpResult;
import cn.zhxu.okhttps.OkHttps;
import cn.zhxu.toys.util.DigestUtils;

import java.util.*;

/**
 * 联麓短信发送器
 * @author Troy.Zhou
 * @since 0.2.1
 */
public class LianLuMsgSender extends AbstractMsgSender {

	public static String DEFAULT_ENDPOINT = "https://apis.shlianlu.com/sms/trade/template/send";

	private String endpoint = DEFAULT_ENDPOINT;

	private String mchId;
	private String appId;
	private String appKey;
	private String version = "1.1.0";

	@Override
	public void init(Map<String, String> params) {
		String endpoint = params.get("endpoint");
		String mchId = params.get("mchId");
		String appId = params.get("appId");
		String appKey = params.get("appKey");
		String version = params.get("version");
		if (mchId == null) {
			throw new MsgSenderInitException("缺少参数：mchId");
		}
		if (appId == null) {
			throw new MsgSenderInitException("缺少参数：appId");
		}
		if (appKey == null) {
			throw new MsgSenderInitException("缺少参数：appKey");
		}
		if (endpoint != null) {
			this.endpoint = endpoint;
		}
		this.mchId = mchId;
		this.appId = appId;
		this.appKey = appKey;
		if (version != null) {
			this.version = version;
		}
	}

	@Override
	public SendResult send(String phone, MsgTemplate template, String... tmplArgs) {
		Map<String, Object> params = new HashMap<>();
		params.put("MchId", mchId);
		params.put("AppId", appId);
		params.put("Version", version);
		params.put("Type", "3");
		params.put("PhoneNumberSet", Collections.singletonList(phone));
		params.put("TemplateId", template.getTmplValue());
		params.put("TemplateParamSet", tmplArgs);
		String timestamp = String.valueOf(System.currentTimeMillis());
		params.put("TimeStamp", timestamp);
		params.put("SignType", "MD5");
		String source = "AppId=" + appId + "&MchId=" + mchId + "&SignType=MD5&TemplateId=" + template.getTmplValue() +
				"&TimeStamp=" + timestamp + "&Type=3&Version=" + version + "&key=" + appKey;
		params.put("Signature", DigestUtils.toMd5(source).toUpperCase());
		try {
			return doSend(phone, params);
		} catch (Exception e) {
			throw new RuntimeException("联麓短信发送异常：", e);
		}
	}

	private SendResult doSend(String phone, Map<String, Object> params) {
		log.info("send params [{}] = {}", phone, params);
		HttpResult result = OkHttps.sync(endpoint)
				.bodyType(OkHttps.JSON)
				.setBodyPara(params)
				.post();
		if (!result.isSuccessful()) {
			String message = "联麓短信返回状态码错误：" + result.getStatus();
			log.error(message);
			return SendResult.fail(message);
		}
		Mapper json = result.getBody().toMapper();
		if (json.getString("status").equals("00")) {
			return SendResult.ok();
		} else {
			log.error("联麓短信发送不成功：{}", json);
			return SendResult.fail(json.toString());
		}
	}

	public String getEndpoint() {
		return endpoint;
	}

	public void setEndpoint(String endpoint) {
		this.endpoint = endpoint;
	}

	public String getMchId() {
		return mchId;
	}

	public void setMchId(String mchId) {
		this.mchId = mchId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public String getAppId() {
		return appId;
	}

	public String getAppKey() {
		return appKey;
	}

	public void setAppKey(String appKey) {
		this.appKey = appKey;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

}
