/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.captcha.impl;

import cn.zhxu.toys.captcha.Captcha;
import cn.zhxu.toys.util.StringUtils;

public class CaptchaBean
implements Captcha {
    private String code;
    private long expireTime;
    private int trys;

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public boolean isExpired() {
        return this.expireTime < System.currentTimeMillis() / 1000L;
    }

    @Override
    public int increaseTrys() {
        return ++this.trys;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public void setTrys(int trys) {
        this.trys = trys;
    }

    @Override
    public String serialize() {
        return this.expireTime + "," + this.code + "," + this.trys;
    }

    public static CaptchaBean parse(String str) {
        if (StringUtils.isBlank(str)) {
            return null;
        }
        String[] splits = str.split(",");
        if (splits.length < 2) {
            return null;
        }
        CaptchaBean bean = new CaptchaBean();
        bean.setExpireTime(Long.parseLong(splits[0]));
        bean.setCode(splits[1]);
        if (splits.length >= 3) {
            bean.setTrys(Integer.parseInt(splits[2]));
        }
        return bean;
    }
}

