/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.cipher;

import cn.zhxu.toys.cipher.Encryptor;
import cn.zhxu.toys.cipher.Md5Utils;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;

public class SimpleEncryptor
implements Encryptor {
    protected byte[] secret;

    public SimpleEncryptor() {
    }

    public SimpleEncryptor(byte[] secret) {
        this.doInit(secret);
    }

    public SimpleEncryptor(String secret) {
        this.init(secret);
    }

    @Override
    public void init(String secret) {
        this.doInit(secret.getBytes(StandardCharsets.UTF_8));
    }

    protected void doInit(byte[] secret) {
        this.secret = Md5Utils.toMd5(secret);
    }

    @Override
    public byte[] encrypt(byte[] plainBytes) {
        return this.doEncrypt(this.secret, plainBytes);
    }

    @Override
    public byte[] encrypt(byte[] secretBytes, byte[] plainBytes) {
        secretBytes = Md5Utils.toMd5(secretBytes);
        return this.doEncrypt(secretBytes, plainBytes);
    }

    @Override
    public String encrypt(String plainText) {
        byte[] bytes = this.doEncrypt(this.secret, plainText.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBase64String((byte[])bytes);
    }

    @Override
    public String encrypt(String secretText, String plainText) {
        byte[] secretBytes = secretText.getBytes(StandardCharsets.UTF_8);
        byte[] plainBytes = plainText.getBytes(StandardCharsets.UTF_8);
        byte[] bytes = this.encrypt(secretBytes, plainBytes);
        return Base64.encodeBase64String((byte[])bytes);
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] doEncrypt(byte[] secretBytes, byte[] plainBytes) {
        try {
            void var7_16;
            void var7_14;
            byte sumx = 0;
            for (byte by : plainBytes) {
                sumx = (byte)((sumx + by) % 256);
            }
            byte sumy = 0;
            byte[] byArray = secretBytes;
            int n = byArray.length;
            boolean bl = false;
            while (var7_14 < n) {
                byte b = byArray[var7_14];
                sumy = (byte)((sumy + b) % 256);
                ++var7_14;
            }
            int textLength = plainBytes.length;
            byte[] sBytes = new byte[textLength];
            boolean bl2 = false;
            while (var7_16 < textLength) {
                void si = var7_16 % secretBytes.length;
                sBytes[var7_16] = (byte)((secretBytes[si] + sumx) % 256);
                ++var7_16;
            }
            byte[] byArray2 = new byte[textLength + 1];
            byArray2[textLength] = (byte)((sumx + sumy) % 256);
            for (int i = 0; i < textLength; ++i) {
                byArray2[i] = (byte)((sBytes[i] + plainBytes[i]) % 256);
            }
            return byArray2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

