/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.msg;

import cn.zhxu.data.Mapper;
import cn.zhxu.okhttps.HttpResult;
import cn.zhxu.okhttps.OkHttps;
import cn.zhxu.okhttps.SHttpTask;
import cn.zhxu.toys.msg.AbstractMsgSender;
import cn.zhxu.toys.msg.MsgTemplate;
import cn.zhxu.toys.msg.SendResult;
import cn.zhxu.toys.util.DigestUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LianLuMsgSender
extends AbstractMsgSender {
    public static String DEFAULT_ENDPOINT = "https://apis.shlianlu.com/sms/trade/template/send";
    private String endpoint = DEFAULT_ENDPOINT;
    private String mchId;
    private String appId;
    private String appKey;
    private String version = "1.1.0";

    @Override
    public void init(Map<String, String> params) {
        String endpoint = params.get("endpoint");
        String mchId = params.get("mchId");
        String appId = params.get("appId");
        String appKey = params.get("appKey");
        String version = params.get("version");
        if (mchId == null) {
            throw new AbstractMsgSender.MsgSenderInitException("\u7f3a\u5c11\u53c2\u6570\uff1amchId");
        }
        if (appId == null) {
            throw new AbstractMsgSender.MsgSenderInitException("\u7f3a\u5c11\u53c2\u6570\uff1aappId");
        }
        if (appKey == null) {
            throw new AbstractMsgSender.MsgSenderInitException("\u7f3a\u5c11\u53c2\u6570\uff1aappKey");
        }
        if (endpoint != null) {
            this.endpoint = endpoint;
        }
        this.mchId = mchId;
        this.appId = appId;
        this.appKey = appKey;
        if (version != null) {
            this.version = version;
        }
    }

    @Override
    public SendResult send(String phone, MsgTemplate template, String ... tmplArgs) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("MchId", this.mchId);
        params.put("AppId", this.appId);
        params.put("Version", this.version);
        params.put("Type", "3");
        params.put("PhoneNumberSet", Collections.singletonList(phone));
        params.put("TemplateId", template.getTmplValue());
        params.put("TemplateParamSet", tmplArgs);
        String timestamp = String.valueOf(System.currentTimeMillis());
        params.put("TimeStamp", timestamp);
        params.put("SignType", "MD5");
        String source = "AppId=" + this.appId + "&MchId=" + this.mchId + "&SignType=MD5&TemplateId=" + template.getTmplValue() + "&TimeStamp=" + timestamp + "&Type=3&Version=" + this.version + "&key=" + this.appKey;
        params.put("Signature", DigestUtils.toMd5(source).toUpperCase());
        try {
            return this.doSend(phone, params);
        }
        catch (Exception e) {
            throw new RuntimeException("\u8054\u9e93\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38\uff1a", e);
        }
    }

    private SendResult doSend(String phone, Map<String, Object> params) {
        this.log.info("send params [{}] = {}", (Object)phone, params);
        HttpResult result = ((SHttpTask)((SHttpTask)OkHttps.sync((String)this.endpoint).bodyType("json")).setBodyPara(params)).post();
        if (!result.isSuccessful()) {
            String message = "\u8054\u9e93\u77ed\u4fe1\u8fd4\u56de\u72b6\u6001\u7801\u9519\u8bef\uff1a" + result.getStatus();
            this.log.error(message);
            return SendResult.fail(message);
        }
        Mapper json = result.getBody().toMapper();
        if (json.getString("status").equals("00")) {
            return SendResult.ok();
        }
        this.log.error("\u8054\u9e93\u77ed\u4fe1\u53d1\u9001\u4e0d\u6210\u529f\uff1a{}", (Object)json);
        return SendResult.fail(json.toString());
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getMchId() {
        return this.mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

