/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.util;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RsaUtils {
    public static final String ALGORITHM = "RSA";
    private static final int DEFAULT_KEY_SIZE = 1024;

    public static RsaKey generateKey() {
        return RsaUtils.generateKey(1024);
    }

    public static RsaKey generateKey(int keySize) {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u5b9e\u4f8b\u5316RSA\u5bc6\u94a5\u751f\u6210\u5668\u5f02\u5e38\uff1a", e);
        }
        keyPairGenerator.initialize(keySize);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        return new RsaKey(publicKey, privateKey);
    }

    public static byte[] encryptByPrivateKey(byte[] data, byte[] key) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(key);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        return RsaUtils.encryptByPrivateKey(data, privateKey);
    }

    public static byte[] encryptByPrivateKey(byte[] data, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, privateKey);
        return cipher.doFinal(data);
    }

    public static byte[] encryptByPublicKey(byte[] data, byte[] key) throws Exception {
        return RsaUtils.encryptByPublicKey(data, key, ALGORITHM);
    }

    public static byte[] encryptByPublicKey(byte[] data, byte[] key, String algorithm) throws Exception {
        if (algorithm == null || algorithm.equals("")) {
            throw new IllegalArgumentException("algorithm can not be null");
        }
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(key);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        return RsaUtils.encryptByPublicKey(data, publicKey, algorithm);
    }

    public static byte[] encryptByPublicKey(byte[] data, PublicKey publicKey, String algorithm) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, publicKey);
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPrivateKey(byte[] data, byte[] key) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(key);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        return RsaUtils.decryptByPrivateKey(data, privateKey);
    }

    public static byte[] decryptByPrivateKey(byte[] data, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, privateKey);
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPublicKey(byte[] data, byte[] key) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(key);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        return RsaUtils.decryptByPublicKey(data, publicKey);
    }

    public static byte[] decryptByPublicKey(byte[] data, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, publicKey);
        return cipher.doFinal(data);
    }

    public static class RsaKey {
        private final PublicKey publicKey;
        private final PrivateKey privateKey;
        private byte[] publicKeyBytes;
        private byte[] privateKeyBytes;

        public RsaKey(PublicKey publicKey, PrivateKey privateKey) {
            this.publicKey = publicKey;
            this.privateKey = privateKey;
        }

        public PublicKey getPublicKey() {
            return this.publicKey;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public byte[] getPublicKeyBytes() {
            if (this.publicKeyBytes == null) {
                this.publicKeyBytes = this.publicKey.getEncoded();
            }
            return this.publicKeyBytes;
        }

        public byte[] getPrivateKeyBytes() {
            if (this.privateKeyBytes == null) {
                this.privateKeyBytes = this.privateKey.getEncoded();
            }
            return this.privateKeyBytes;
        }
    }
}

