/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.cache;

import cn.zhxu.toys.cache.AbstractCacheService;
import cn.zhxu.toys.cache.CacheGetter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisTemplateCacheService
extends AbstractCacheService {
    private StringRedisTemplate redisTemplate;

    public RedisTemplateCacheService() {
    }

    public RedisTemplateCacheService(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    @Override
    public void cache(String key, int timeoutSeconds, Object object) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)this.toString(object), (long)timeoutSeconds, TimeUnit.SECONDS);
    }

    @Override
    protected <T> T doCache(String key, int timeoutSeconds, Type resType, CacheGetter<T> getter) {
        String cache = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (cache != null) {
            return this.toBean(cache, resType);
        }
        if (timeoutSeconds > 0 && getter != null) {
            T object = getter.doGet();
            this.cache(key, timeoutSeconds, object);
            return object;
        }
        return null;
    }

    @Override
    protected <T> List<T> doCacheList(String key, int timeoutSeconds, Class<T> resType, CacheGetter<List<T>> getter) {
        String cache = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (cache != null) {
            return this.toList(cache, resType);
        }
        if (timeoutSeconds > 0 && getter != null) {
            List<T> list = getter.doGet();
            this.cache(key, timeoutSeconds, list);
            return list;
        }
        return null;
    }

    public void setRedisTemplate(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public StringRedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }
}

