/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.concurrent;

import cn.zhxu.toys.concurrent.AbstractSyncLock;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

public class RedisTemplateSyncLock
extends AbstractSyncLock {
    static Logger log = LoggerFactory.getLogger(RedisTemplateSyncLock.class);
    private StringRedisTemplate redisTemplate;

    @Override
    protected boolean doTryLock(String key, String requestId, int maxHoldSeconds) {
        return Boolean.TRUE.equals(this.redisTemplate.execute(connection -> {
            RedisSerializer keySerializer = this.redisTemplate.getKeySerializer();
            RedisSerializer valueSerializer = this.redisTemplate.getValueSerializer();
            Object result = connection.execute("set", (byte[][])new byte[][]{keySerializer.serialize((Object)key), valueSerializer.serialize((Object)requestId), "NX".getBytes(StandardCharsets.UTF_8), "EX".getBytes(StandardCharsets.UTF_8), String.valueOf(maxHoldSeconds).getBytes(StandardCharsets.UTF_8)});
            if (result != null) {
                String res = result instanceof byte[] ? new String((byte[])result) : result.toString();
                log.debug("GET_LOCK[" + key + "]: " + res);
                return res.toUpperCase().contains("OK");
            }
            log.debug("GET_LOCK[" + key + "]: null");
            return false;
        }));
    }

    @Override
    protected void doUnLock(String key, String requestId) {
        this.redisTemplate.execute(connection -> {
            String script = "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('del', KEYS[1]) end";
            return connection.eval(script.getBytes(StandardCharsets.UTF_8), ReturnType.VALUE, 1, (byte[][])new byte[][]{key.getBytes(StandardCharsets.UTF_8), requestId.getBytes(StandardCharsets.UTF_8)});
        });
        log.debug("DEL_LOCK: " + key);
    }

    public StringRedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

