package cn.zhxu.toys.msg;

/**
 * 发送结果
 * @since v0.2.2
 */
public class SendResult {

    private boolean ok;
    private String msg;

    public SendResult() {
    }

    public SendResult(boolean ok, String msg) {
        this.ok = ok;
        this.msg = msg;
    }

    public static SendResult ok() {
        return new SendResult(true, null);
    }

    public static SendResult ok(String msg) {
        return new SendResult(true, msg);
    }

    public static SendResult fail(String msg) {
        return new SendResult(false, msg);
    }

    public boolean isOk() {
        return ok;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Override
    public String toString() {
        return "{ok=" + ok + ", msg=" + msg + '}';
    }

}
