/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.captcha.impl;

import cn.zhxu.toys.cache.CacheService;
import cn.zhxu.toys.captcha.Captcha;
import cn.zhxu.toys.captcha.CaptchaStorage;
import cn.zhxu.toys.captcha.impl.CaptchaBean;

public class DefaultCaptchaStorage
implements CaptchaStorage {
    private CacheService cacheService;
    private String keyPrefix = "captcha";
    private int cacheSeconds = 1800;

    public DefaultCaptchaStorage() {
    }

    public DefaultCaptchaStorage(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Override
    public Captcha findCaptcha(String captchaId) {
        String data = this.cacheService.cache(this.key(captchaId), String.class);
        if (data != null) {
            return CaptchaBean.parse(data);
        }
        return null;
    }

    @Override
    public void save(String captchaId, String code, int expireSeconds) {
        CaptchaBean captcha = new CaptchaBean();
        captcha.setCode(code);
        captcha.setExpireTime(System.currentTimeMillis() / 1000L + (long)expireSeconds);
        this.cacheService.cache(this.key(captchaId), this.cacheSeconds, captcha.serialize());
    }

    @Override
    public void save(String captchaId, Captcha captcha) {
        if (captcha != null) {
            this.cacheService.cache(this.key(captchaId), this.cacheSeconds, captcha.serialize());
        }
    }

    @Override
    public void delete(String captchaId) {
        this.cacheService.delete(this.key(captchaId));
    }

    protected String key(String captchaId) {
        return this.keyPrefix + ":" + captchaId;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public CacheService getCacheService() {
        return this.cacheService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public int getCacheSeconds() {
        return this.cacheSeconds;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheSeconds = cacheSeconds;
    }
}

