/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.concurrent;

public class SnowIdGenerator {
    private static final long BASE_TIMESTAMP = 1735660800000L;
    private final long machineId;
    private final int machineBits;
    private final int serialBits;
    private final int timeRSBits;
    private volatile long sequence = 0L;

    public SnowIdGenerator(long machineId) {
        this(machineId, 10, 12, 0);
    }

    public SnowIdGenerator(long machineId, int timeRSBits) {
        this(machineId, 10, 12, timeRSBits);
    }

    public SnowIdGenerator(long machineId, int machineBits, int serialBits, int timeRSBits) {
        this.machineId = machineId;
        this.machineBits = machineBits;
        this.serialBits = serialBits;
        this.timeRSBits = timeRSBits;
    }

    public synchronized long nextId() {
        long timestamp = System.currentTimeMillis() - 1735660800000L >> this.timeRSBits;
        if (++this.sequence >= 1L << this.serialBits) {
            this.sequence = 0L;
        }
        return timestamp << this.machineBits + this.serialBits | this.machineId << this.serialBits | this.sequence;
    }
}

