/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.util;

import cn.zhxu.toys.util.StringUtils;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class AesUtils {
    private static final String KEY_MODE = "AES";
    private static final int KEY_LENGTH = 128;
    private Cipher encryptCipher = null;
    private Cipher decryptCipher = null;

    public AesUtils(String strKey) throws Exception {
        KeyGenerator generator = KeyGenerator.getInstance(KEY_MODE);
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(strKey.getBytes());
        generator.init(128, secureRandom);
        SecretKey secretKey = generator.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, KEY_MODE);
        this.encryptCipher = Cipher.getInstance(KEY_MODE);
        this.encryptCipher.init(1, key);
        this.decryptCipher = Cipher.getInstance(KEY_MODE);
        this.decryptCipher.init(2, key);
    }

    public byte[] encrypt(byte[] arr) throws Exception {
        return this.encryptCipher.doFinal(arr);
    }

    public String encrypt(String strIn) throws Exception {
        return StringUtils.toHexStr(this.encrypt(strIn.getBytes(StandardCharsets.UTF_8)));
    }

    public byte[] decrypt(byte[] arr) throws Exception {
        return this.decryptCipher.doFinal(arr);
    }

    public String decrypt(String strIn) throws Exception {
        return new String(this.decrypt(Hex.decodeHex((char[])strIn.toCharArray())), StandardCharsets.UTF_8);
    }

    public static void main(String[] args) throws Exception {
        AesUtils aes = new AesUtils("123");
        String result = aes.encrypt("123456");
        System.out.println("result = " + result);
    }
}

