package cn.zhxu.toys.msg;


/**
 * 信息发送接口
 * @author Troy.Zhou
 */

public interface MsgSender {

	/**
	 * 若存在多层代理，则取其最里层的真实名称，而非代理名称
	 * @return 发送器名称
	 * @since 0.5.0
	 */
	String name();

	/**
	 * 发送信息
	 * @param phone 手机号
	 * @param tmplName 模板名称
	 * @param tmplArgs 模板参数值
	 * @return 是否发送成功
	 */
	SendResult send(String phone, String tmplName, String... tmplArgs);

}
